/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh;

import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshConstants;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import math.geom2d.line.StraightLine2D;

public class NavMeshBSPNode
implements Serializable {
    private static final long serialVersionUID = 3893164811677500677L;
    public transient NavMesh navmesh;
    public ArrayList polys;
    public NavMeshBSPNode parent;
    public StraightLine2D sepLine;
    public NavMeshBSPNode left;
    public NavMeshBSPNode right;
    private Random random;

    public NavMeshBSPNode(NavMesh m, NavMeshBSPNode par) {
        this.navmesh = m;
        this.parent = par;
        this.polys = new ArrayList();
        this.random = new Random();
        this.sepLine = null;
    }

    public boolean shouldSplit() {
        return this.polys.size() > NavMeshConstants.stopSplittingNumberOfPolygons;
    }

    public StraightLine2D findSeparatingLine() throws Exception {
        double bestFoundSplitFactor = NavMeshConstants.maxAllowedSplitFactor;
        StraightLine2D bestFoundSeparatingLine = null;
        ArrayList candidatePolygons = (ArrayList)this.polys.clone();
        for (int i = 0; i < NavMeshConstants.maxNumberOfPolygonsToTry && !candidatePolygons.isEmpty(); ++i) {
            int randomId = 0;
            Integer polygonId = (Integer)candidatePolygons.get(randomId);
            int[] polygon = this.navmesh.getPolygon(polygonId);
            for (int j = 0; j < polygon.length; ++j) {
                int v1 = polygon[j];
                int v2 = polygon[(j + 1) % polygon.length];
                double[] vertex1 = this.navmesh.getVertex(v1);
                double[] vertex2 = this.navmesh.getVertex(v2);
                math.geom2d.Point2D point2D1 = new math.geom2d.Point2D(vertex1[0], vertex1[1]);
                math.geom2d.Point2D point2D2 = new math.geom2d.Point2D(vertex2[0], vertex2[1]);
                StraightLine2D separatingLine = new StraightLine2D((Point2D)point2D1, (Point2D)point2D2);
                ArrayList[] splittedPolys = this.splitPolygonsByLine(this.polys, separatingLine);
                ArrayList left = splittedPolys[0];
                ArrayList right = splittedPolys[1];
                int intersectedPolygons = left.size() + right.size() - this.polys.size();
                double splitFactor = this.max(left.size() / this.polys.size(), right.size() / this.polys.size());
                if (!(splitFactor < bestFoundSplitFactor)) continue;
                bestFoundSeparatingLine = separatingLine;
                bestFoundSplitFactor = splitFactor;
            }
            candidatePolygons.remove(polygonId);
        }
        if (bestFoundSeparatingLine == null) {
            throw new Exception("No good separating line have been found. Splitting " + this.polys.size() + " polygons unsuccessfull.");
        }
        return bestFoundSeparatingLine;
    }

    private ArrayList[] splitPolygonsByLine(ArrayList polysToSplit, StraightLine2D separatingLine) throws Exception {
        ArrayList<Integer> left = new ArrayList<Integer>();
        ArrayList<Integer> right = new ArrayList<Integer>();
        for (int i = 0; i < polysToSplit.size(); ++i) {
            boolean isOnLeft = false;
            boolean isOnRight = false;
            Integer pId = (Integer)polysToSplit.get(i);
            int[] polygon = this.navmesh.getPolygon(pId);
            for (int j = 0; j < polygon.length; ++j) {
                int vId = polygon[j];
                double[] vertex = this.navmesh.getVertex(vId);
                math.geom2d.Point2D point2D = new math.geom2d.Point2D(vertex[0], vertex[1]);
                double dist = separatingLine.getSignedDistance((Point2D)point2D);
                if (dist < 0.0) {
                    isOnLeft = true;
                }
                if (dist > 0.0) {
                    isOnRight = true;
                }
                if (isOnLeft && isOnRight) break;
            }
            if (isOnLeft) {
                left.add(pId);
            }
            if (isOnRight) {
                right.add(pId);
            }
            if (isOnLeft || isOnRight) continue;
            throw new Exception("Something is wrong. The polygon number " + pId + " seems to be on neither side of the separating line.");
        }
        ArrayList[] ret = new ArrayList[]{left, right};
        return ret;
    }

    public void build() {
        block7: {
            if (!this.shouldSplit()) {
                if (this.polys.size() > this.navmesh.getNumberOfPolygonsInBiggestLeaf()) {
                    this.navmesh.setBiggestLeafInTree(this);
                }
                return;
            }
            try {
                this.sepLine = this.findSeparatingLine();
            }
            catch (Exception e) {
                if (this.polys.size() <= this.navmesh.getNumberOfPolygonsInBiggestLeaf()) break block7;
                this.navmesh.setBiggestLeafInTree(this);
            }
        }
        if (this.sepLine != null) {
            try {
                ArrayList[] splittedPolys = this.splitPolygonsByLine(this.polys, this.sepLine);
                this.left = new NavMeshBSPNode(this.navmesh, this);
                this.left.polys = splittedPolys[0];
                this.left.build();
                this.right = new NavMeshBSPNode(this.navmesh, this);
                this.right.polys = splittedPolys[1];
                this.right.build();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private double max(double d1, double d2) {
        return d1 > d2 ? d1 : d2;
    }

    public boolean isLeaf() {
        return this.left == null && this.right == null;
    }
}

