/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor.visibility;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.visibility.model.VisibilityLocation;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.visibility.model.VisibilityMatrix;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import cz.cuni.amis.pogamut.ut2004.utils.PogamutUT2004Property;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.SafeEquals;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class Visibility
extends SensorModule<UT2004Bot> {
    GameInfoListener gameInfoListener;
    GameInfo lastGameInfo;
    MapPointListener mapPointListener;
    VisibilityMatrix matrix = null;
    AgentInfo info;

    public boolean isInitialized() {
        return this.matrix != null;
    }

    public VisibilityMatrix getMatrix() {
        return this.matrix;
    }

    public VisibilityLocation getNearestVisibilityLocationTo(ILocated located) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.matrix.getNearest(located);
    }

    public VisibilityLocation getNearestVisibilityLocation() {
        return this.getNearestVisibilityLocationTo((ILocated)this.info.getLocation());
    }

    public NavPoint getNearestNavPointTo(ILocated located) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.matrix.getNearestNavPoint(located);
    }

    public NavPoint getNearestNavPopint() {
        return this.getNearestNavPointTo((ILocated)this.info.getLocation());
    }

    public boolean isVisible(ILocated loc1, ILocated loc2) {
        if (!this.isInitialized()) {
            return false;
        }
        return this.matrix.isVisible(loc1, loc2);
    }

    public boolean isVisible(ILocated target) {
        return this.isVisible((ILocated)this.info.getLocation(), target);
    }

    public Set<VisibilityLocation> getCoverPointsFrom(ILocated loc) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.matrix.getCoverPoints(loc);
    }

    public Set<VisibilityLocation> getHiddenPoints() {
        return this.getCoverPointsFrom((ILocated)this.info.getLocation());
    }

    public VisibilityLocation getNearestCoverPointFrom(ILocated enemy) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.matrix.getNearestCoverPoint((ILocated)this.info.getLocation(), enemy);
    }

    public Set<VisibilityLocation> getVisiblePointsFrom(ILocated loc) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.matrix.getVisiblePoints(loc);
    }

    public Set<VisibilityLocation> getVisiblePoints() {
        return this.getVisiblePointsFrom((ILocated)this.info.getLocation());
    }

    public Set<NavPoint> getCoverNavPointsFrom(ILocated loc) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.matrix.getCoverNavPoints(loc);
    }

    public Set<NavPoint> getHiddenNavPoints() {
        return this.getCoverNavPointsFrom((ILocated)this.info.getLocation());
    }

    public NavPoint getNearestCoverNavPointFrom(ILocated enemy) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.matrix.getNearestCoverNavPoint(enemy);
    }

    public Set<NavPoint> getVisibleNavPointsFrom(ILocated loc) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.matrix.getVisibleNavPoints(loc);
    }

    public Set<NavPoint> getVisibleNavPoints() {
        if (!this.isInitialized()) {
            return null;
        }
        return this.matrix.getVisibleNavPoints((ILocated)this.info.getLocation());
    }

    public Set<VisibilityLocation> getCoverPointsFromN(ILocated ... enemies) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.matrix.getCoverPointsN(enemies);
    }

    public VisibilityLocation getNearestCoverPointFromN(ILocated target, ILocated ... enemies) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.matrix.getNearestCoverPointN(target, enemies);
    }

    public VisibilityLocation getNearestCoverPointN(ILocated ... enemies) {
        return this.getNearestCoverPointFromN((ILocated)this.info.getLocation(), enemies);
    }

    public Set<NavPoint> getCoverNavPointsFromN(ILocated ... enemies) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.matrix.getCoverNavPointsN(enemies);
    }

    public NavPoint getNearestCoverNavPointFromN(ILocated target, ILocated ... enemies) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.matrix.getNearestCoverNavPointN(target, enemies);
    }

    public NavPoint getNearestCoverNavPointN(ILocated ... enemies) {
        return this.getNearestCoverNavPointFromN((ILocated)this.info.getLocation(), enemies);
    }

    void init(GameInfo gameInfo, MapPointListObtained event) {
        if (gameInfo == null || event == null) {
            this.log.warning("Cannot initialize." + (gameInfo == null ? " GameInfo is NULL." : "") + (event == null ? " MapPoints is NULL." : ""));
            return;
        }
        Map<UnrealId, NavPoint> navPoints = event.getNavPoints();
        if (navPoints == null) {
            this.log.warning("Cannot map visibility locations to NavPoints and Links, nav points not exported by GameBots2004...");
            this.log.warning("Module cannot be initialized.");
            return;
        }
        String mapName = gameInfo.getLevel();
        this.log.warning("Initializing visibility matrix for map: " + mapName);
        File file1 = VisibilityMatrix.getFile_All(new File("."), mapName);
        this.log.info("Looking for file: " + file1.getAbsolutePath());
        VisibilityMatrix visibilityMatrix = this.tryToLoadVisibilityMatrix(new File("."), mapName);
        if (visibilityMatrix == null) {
            String dir = Pogamut.getPlatform().getProperty(PogamutUT2004Property.POGAMUT_UT2004_VISIBILITY_DIRECTORY.getKey());
            if (dir == null) {
                this.log.warning("Could not load visibility information for " + mapName + ". File from local dir " + file1.getAbsolutePath() + " not found and property " + PogamutUT2004Property.POGAMUT_UT2004_VISIBILITY_DIRECTORY.getKey() + " not set.");
            } else {
                File dirFile = new File(dir);
                if (dirFile.exists() && dirFile.isDirectory()) {
                    File file2 = VisibilityMatrix.getFile_All(dirFile, mapName);
                    this.log.info("Looking for file: " + file2.getAbsolutePath());
                    visibilityMatrix = this.tryToLoadVisibilityMatrix(new File("."), mapName);
                    if (visibilityMatrix == null) {
                        this.log.warning("Could not load visibility information for " + mapName + ". File from local dir " + file1.getAbsolutePath() + " not found and file from configured dir " + file2.getAbsolutePath() + " was not found as well.");
                    }
                } else {
                    this.log.warning("Could not load visibility information for " + mapName + ". File from local dir " + file1.getAbsolutePath() + " not found and property " + PogamutUT2004Property.POGAMUT_UT2004_VISIBILITY_DIRECTORY.getKey() + " leads to non-dir " + dirFile.getAbsolutePath() + ".");
                }
            }
        }
        if (visibilityMatrix == null) {
            this.log.warning("Visibility matrix was not loaded, module could not be initialized.");
            return;
        }
        this.log.warning("Visibility matrix loaded successfully.");
        this.log.info("Mapping navpoints and links...");
        for (Map.Entry<Integer, VisibilityLocation> vLocEntry : visibilityMatrix.getLocations().entrySet()) {
            VisibilityLocation vLoc = vLocEntry.getValue();
            if (vLoc.navPoint1Id != null) {
                if (vLoc.navPoint2Id != null) {
                    String navPoint1Id = mapName + "." + vLoc.navPoint1Id;
                    NavPoint np1 = navPoints.get(UnrealId.get((String)navPoint1Id));
                    if (np1 == null) {
                        this.log.warning("Could not find navpoint (map changed? / old visibility matrix file?): " + navPoint1Id);
                        continue;
                    }
                    String navPoint2Id = mapName + "." + vLoc.navPoint2Id;
                    NavPoint np2 = navPoints.get(UnrealId.get((String)navPoint2Id));
                    if (np2 == null) {
                        this.log.warning("Could not find navpoint (map changed? / old visibility matrix file?): " + navPoint2Id);
                        continue;
                    }
                    NavPointNeighbourLink link = np1.getOutgoingEdges().get(np2.getId());
                    if (link == null) {
                        link = np2.getOutgoingEdges().get(np1.getId());
                        this.log.warning("Could not find navpoint link (map changed? / old visibility matrix file?): " + navPoint1Id + " <-> " + navPoint2Id);
                        continue;
                    }
                    vLoc.link = link;
                    continue;
                }
                String navPointId = mapName + "." + vLoc.navPoint1Id;
                vLoc.navPoint = navPoints.get(UnrealId.get((String)navPointId));
                if (vLoc.navPoint != null) continue;
                this.log.warning("Could not find navpoint (map changed? / old visibility matrix file?): " + navPointId);
                continue;
            }
            this.log.warning("Malformed VisibilityLocation under index " + vLocEntry.getKey() + ", it does not have navPoint1Id specified!");
        }
        this.matrix = visibilityMatrix;
        this.log.warning("Navpoints and links mapped, module is ready to be used.");
    }

    private VisibilityMatrix tryToLoadVisibilityMatrix(File directory, String mapName) {
        File file = VisibilityMatrix.getFile_All(directory, mapName);
        if (file.exists() && file.isFile()) {
            try {
                VisibilityMatrix visibilityMatrix = VisibilityMatrix.load(directory, mapName);
                if (!SafeEquals.equals((Object)mapName, (Object)visibilityMatrix.getMapName())) {
                    this.log.warning("Expected to load visibility matrix for map " + mapName + ", but matrix for " + visibilityMatrix.getMapName() + " loaded instead! (Misplaced file?) Module cannot be used.");
                    return null;
                }
                return visibilityMatrix;
            }
            catch (Exception e) {
                this.log.warning(ExceptionToString.process((String)("Failed to load visibility matrix from existing file " + file.getAbsolutePath() + "."), (Throwable)e));
            }
        }
        return null;
    }

    public Visibility(UT2004Bot bot, AgentInfo info) {
        this(bot, info, null);
    }

    public Visibility(UT2004Bot bot, AgentInfo info, Logger log) {
        super((IObservingAgent)bot, log);
        this.info = info;
        NullCheck.check((Object)((Object)this.info), (String)"agentInfo");
        this.gameInfoListener = new GameInfoListener(this.worldView);
        this.mapPointListener = new MapPointListener(this.worldView);
        this.cleanUp();
    }

    protected void cleanUp() {
        super.cleanUp();
        this.matrix = null;
    }

    private class MapPointListener
    implements IWorldEventListener<MapPointListObtained> {
        public void notify(MapPointListObtained event) {
            Visibility.this.init(Visibility.this.lastGameInfo, event);
        }

        public MapPointListener(IWorldView worldView) {
            worldView.addEventListener(MapPointListObtained.class, (IWorldEventListener)this);
        }
    }

    private class GameInfoListener
    implements IWorldObjectEventListener<GameInfo, IWorldObjectEvent<GameInfo>> {
        public void notify(IWorldObjectEvent<GameInfo> event) {
            Visibility.this.lastGameInfo = (GameInfo)event.getObject();
        }

        public GameInfoListener(IWorldView worldView) {
            worldView.addObjectListener(GameInfo.class, (IWorldObjectEventListener)this);
        }
    }
}

