/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector;

import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AccUT2004PositionStuckDetector
implements IStuckDetector {
    private static double DEFAULT_MIN_DIAMETER = 60.0;
    private static double DEFAULT_MIN_Z = 80.0;
    private static int DEFAULT_HISTORY_LENGTH = 40;
    private UT2004Bot bot;
    private double minMovementDiameter;
    private int historyLength;
    private List<Location> locationHistory;
    private boolean stuck = false;
    private boolean botWaiting = false;
    private boolean enabled = false;
    private SelfListener selfListener;
    private EndMessageListener endMessageListener;
    private Logger log;
    private double minMovementZ;

    public AccUT2004PositionStuckDetector(UT2004Bot bot) {
        this(bot, DEFAULT_HISTORY_LENGTH, DEFAULT_MIN_DIAMETER, DEFAULT_MIN_Z);
    }

    public AccUT2004PositionStuckDetector(UT2004Bot bot, int historyLength, double minMovementDiameter, double minMovementZ) {
        if (this.log == null) {
            this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        }
        this.bot = bot;
        this.selfListener = new SelfListener((IWorldView)bot.getWorldView());
        this.endMessageListener = new EndMessageListener((IWorldView)bot.getWorldView());
        this.historyLength = historyLength;
        if (this.historyLength < 0) {
            throw new IllegalArgumentException("historyLength can't be < 0");
        }
        this.minMovementDiameter = minMovementDiameter;
        this.minMovementZ = minMovementZ;
        this.locationHistory = new ArrayList<Location>(this.historyLength);
    }

    public void setEnabled(boolean state) {
        if (this.enabled == state) {
            return;
        }
        this.enabled = state;
    }

    public void setBotWaiting(boolean state) {
        this.botWaiting = state;
    }

    public void setBotTarget(ILocated target) {
    }

    public void eventSelf(IWorldObjectEvent<Self> event) {
        if (!this.enabled) {
            return;
        }
        if (this.botWaiting) {
            return;
        }
        this.locationHistory.add(((Self)event.getObject()).getLocation());
        while (this.locationHistory.size() > this.historyLength) {
            this.locationHistory.remove(0);
        }
    }

    public void eventEndMessage(EndMessage event) {
        if (!this.enabled) {
            return;
        }
        if (this.botWaiting) {
            return;
        }
        if (this.locationHistory.size() == this.historyLength) {
            double maxDistance = Double.NEGATIVE_INFINITY;
            double maxHeight = Double.NEGATIVE_INFINITY;
            for (Location loc1 : this.locationHistory) {
                for (Location loc2 : this.locationHistory) {
                    if (maxDistance < loc1.getDistance2D(loc2)) {
                        maxDistance = loc1.getDistance2D(loc2);
                    }
                    if (!(Math.abs(loc1.z - loc2.z) > maxHeight)) continue;
                    maxHeight = Math.abs(loc1.z - loc2.z);
                }
            }
            if (maxDistance < this.minMovementDiameter && maxHeight < this.minMovementZ) {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Bot stuck detected. Distance: " + maxDistance + " < " + this.minMovementDiameter + " && Height: " + maxHeight + " < " + this.minMovementZ);
                }
                this.stuck = true;
            } else {
                this.stuck = false;
            }
        }
    }

    public boolean isStuck() {
        return this.stuck;
    }

    public void reset() {
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("Reset.");
        }
        this.locationHistory.clear();
        this.stuck = false;
    }

    private class EndMessageListener
    implements IWorldEventListener<EndMessage> {
        public EndMessageListener(IWorldView worldView) {
            worldView.addEventListener(EndMessage.class, (IWorldEventListener)this);
        }

        public void notify(EndMessage event) {
            AccUT2004PositionStuckDetector.this.eventEndMessage(event);
        }
    }

    private class SelfListener
    implements IWorldObjectListener<Self> {
        public SelfListener(IWorldView worldView) {
            worldView.addObjectListener(Self.class, (IWorldObjectEventListener)this);
        }

        public void notify(IWorldObjectEvent<Self> event) {
            AccUT2004PositionStuckDetector.this.eventSelf(event);
        }
    }
}

