/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshConstants;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing.BorderPoint;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing.JumpBoundaries;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.utils.LinkFlag;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Vector2d;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.line.Line2D;
import math.geom2d.line.LinearShape2D;

public class JumpModule {
    public static final double MAX_DOUBLE_JUMP_POWER = 755.0;
    public static final double MAX_SINGLE_JUMP_POWER = 340.0;
    private NavMesh navMesh;
    private Logger log;
    public static final double MAX_JUMP_HEIGHT = 130.0;
    private static final double MAX_SINGLE_JUMP_HEIGHT = 60.0;
    private static final double NAVMESH_Z_COORD_CORRECTION = 20.0;
    private static final double SPEED_BOOST_DELAY = 0.1;
    private static final double BOT_RADIUS = 70.0;
    private static final double JUMP_PEEK_TIME = 0.39;
    private static final int BOUNDARY_THRESHOLD = 50;
    private static final double JUMP_SPEED_BOOST = 1.08959;

    public JumpModule(NavMesh mesh, Logger log) {
        this.navMesh = mesh;
        this.log = log;
    }

    public JumpBoundaries computeJumpBoundaries(NavPointNeighbourLink jumpLink) {
        boolean borderToBorder;
        if (jumpLink == null) {
            return new JumpBoundaries(jumpLink);
        }
        NavPoint startNavPoint = jumpLink.getFromNavPoint();
        NavPoint endNavPoint = jumpLink.getToNavPoint();
        Location startLocation = startNavPoint.getLocation();
        Location endLocation = endNavPoint.getLocation();
        Location linkDirection3d = endLocation.sub(startLocation);
        Vector2d linkDirection = new Vector2d(linkDirection3d.x, linkDirection3d.y);
        BorderPoint startBorder = this.getBorderPoint(startLocation, endLocation);
        Location startBorderPoint = startBorder.getPoint();
        Vector2d negatedLinkDirection = new Vector2d(linkDirection);
        negatedLinkDirection.negate();
        BorderPoint endBorderPoint = this.getBorderPoint(endLocation, startLocation);
        if (!endBorderPoint.getPoint().equals(endNavPoint.getLocation(), 1.0)) {
            endBorderPoint.setPoint(endBorderPoint.getPoint().addZ(20.0));
        }
        if (!(borderToBorder = this.isJumpable(startBorderPoint, endBorderPoint.getPoint(), 439.5))) {
            return new JumpBoundaries(jumpLink);
        }
        Location testBoundary = startLocation;
        Location currentBoundary = startBorderPoint;
        boolean boundaryFound = false;
        double distanceToSearch = 0.0;
        do {
            boolean isJumpable;
            if ((isJumpable = this.isJumpable(testBoundary, endBorderPoint.getPoint(), 439.5)) && distanceToSearch < 50.0) {
                currentBoundary = testBoundary;
                boundaryFound = true;
                continue;
            }
            if (isJumpable) {
                currentBoundary = testBoundary;
                testBoundary = this.getNavMeshPoint(testBoundary, startLocation, distanceToSearch /= 2.0);
                continue;
            }
            if (distanceToSearch < 50.0 && distanceToSearch > 0.0) {
                boundaryFound = true;
                continue;
            }
            if (distanceToSearch == 0.0) {
                distanceToSearch = testBoundary.getDistance2D(startBorderPoint);
            }
            testBoundary = this.getNavMeshPoint(testBoundary, startBorderPoint, distanceToSearch /= 2.0);
        } while (!boundaryFound);
        return new JumpBoundaries(jumpLink, currentBoundary, startBorderPoint, startBorder.getDirection(), endBorderPoint.getPoint(), endBorderPoint.getDirection(), endLocation);
    }

    public BorderPoint getBorderPoint(Location start, Location end) {
        int endPolygonId = this.navMesh.getPolygonId(end);
        return this.getBorderPoint(start, end, -1, endPolygonId, start, 0);
    }

    private BorderPoint getBorderPoint(Location start, Location end, int pId, int endPolygonId, Location lastCross, int depth) {
        Line2D ray = new Line2D(start.x, start.y, end.x, end.y);
        if (pId < 0) {
            pId = this.navMesh.getPolygonId(start);
        }
        if (pId < 0 || depth > 250) {
            return new BorderPoint(start, null);
        }
        if (pId == endPolygonId) {
            return new BorderPoint(end, null);
        }
        int currentPolygonId = pId;
        int nextPolygonId = -1;
        Point2D cross = null;
        Point2D cross2 = null;
        int v1 = -1;
        int v2 = -1;
        int c2v1 = -1;
        int c2v2 = -1;
        double[] vertex1 = null;
        double[] vertex2 = null;
        int[] polygon = this.navMesh.getPolygon(currentPolygonId);
        boolean foundFirstCross = false;
        for (int i = 0; i < polygon.length; ++i) {
            v1 = polygon[i];
            v2 = polygon[i == polygon.length - 1 ? 0 : i + 1];
            vertex1 = this.navMesh.getVertex(v1);
            Line2D edge = new Line2D(vertex1[0], vertex1[1], (vertex2 = this.navMesh.getVertex(v2))[0], vertex2[1]);
            cross = ray.getIntersection((LinearShape2D)edge);
            if (cross == null) continue;
            if ((cross.x <= Math.max(edge.p1.x, edge.p2.x) && cross.x >= Math.min(edge.p1.x, edge.p2.x) || Math.abs(cross.x - edge.p1.x) < 1.0E-4) && (cross.x <= Math.max(ray.p1.x, ray.p2.x) && cross.x >= Math.min(ray.p1.x, ray.p2.x) || Math.abs(cross.x - ray.p1.x) < 1.0E-4)) {
                if (foundFirstCross) break;
                cross2 = cross;
                c2v1 = v1;
                c2v2 = v2;
                foundFirstCross = true;
                continue;
            }
            cross = null;
        }
        if (cross2 == null) {
            return new BorderPoint(start, null);
        }
        if (cross == null) {
            cross = cross2;
            v1 = c2v1;
            v2 = c2v2;
            vertex1 = this.navMesh.getVertex(v1);
            vertex2 = this.navMesh.getVertex(v2);
        } else {
            double distToCross2;
            double distToCross = end.getDistance2D(new Location(cross.x, cross.y));
            if (distToCross > (distToCross2 = end.getDistance2D(new Location(cross2.x, cross2.y)))) {
                cross = cross2;
                v1 = c2v1;
                v2 = c2v2;
                vertex1 = this.navMesh.getVertex(v1);
                vertex2 = this.navMesh.getVertex(v2);
            }
        }
        nextPolygonId = this.navMesh.getNeighbourPolygon(currentPolygonId, v1, v2);
        Location vertex1Loc = new Location(vertex1);
        Location vertex2Loc = new Location(vertex2);
        Location crossLocation = new Location(cross.x, cross.y);
        double koef = vertex1Loc.getDistance2D(crossLocation) / vertex1Loc.getDistance2D(vertex2Loc);
        Location border = vertex1Loc.interpolate(vertex2Loc, koef);
        if (nextPolygonId == -1) {
            return new BorderPoint(border.addZ(NavMeshConstants.liftPolygonLocation), vertex2Loc.sub(vertex1Loc));
        }
        if (border.getDistance2D(lastCross) < 2.0) {
            Vector2D directionVector = new Vector2D(end.x - start.x, end.y - start.y);
            directionVector.normalize();
            border = border.addX(directionVector.getX() * 3.0);
            border = border.addY(directionVector.getY() * 3.0);
        }
        this.log.log(Level.INFO, "getBorderPoint(): Border location: {0} Next polygon: {1}", new Object[]{border, nextPolygonId});
        return this.getBorderPoint(border.addZ(NavMeshConstants.liftPolygonLocation), end, nextPolygonId, endPolygonId, border, ++depth);
    }

    public boolean needsJump(NavPointNeighbourLink link) {
        if (link == null) {
            return false;
        }
        if ((link.getFlags() & LinkFlag.JUMP.get()) != 0) {
            return true;
        }
        if (link.isForceDoubleJump()) {
            return true;
        }
        return link.getNeededJump() != null;
    }

    public Double computeJump(Location start, JumpBoundaries boundaries, double velocity, double jumpAngleCos) {
        Location collisionLocation;
        int jumpKoef;
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, "Computing jump. Start: {0} End: {1} Velocity: {2}", new Object[]{start, boundaries.getLandingTarget(), velocity});
        }
        double distance2d = this.getDistance2D(start, boundaries.getLandingTarget(), jumpAngleCos);
        double targetZ = boundaries.getLandingTarget().z - start.z;
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, "Computing jump. Target Z: {0}", targetZ);
        }
        double timeToPassDistance = this.getTimeToPassDistance(distance2d, velocity) - 0.055;
        Double force = this.computeJump(targetZ, timeToPassDistance, jumpAngleCos);
        double originalTime = timeToPassDistance;
        int n = jumpKoef = originalTime > 0.39 ? 2 : 1;
        if (force.equals(Double.NaN) && timeToPassDistance < (double)jumpKoef * 0.39 && targetZ > 0.0) {
            force = this.getPowerForJumpByZDiff(targetZ);
        }
        if (force.equals(Double.NaN) || force < 0.0) {
            return force;
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, "Computing jump. Computed force before collision adjustment: {0}", force);
        }
        if ((collisionLocation = this.getCollisionLocation(boundaries)) == null) {
            return force;
        }
        double collisionDistance = this.getDistance2D(start, collisionLocation, jumpAngleCos);
        double timeToCollision = this.getTimeToPassDistance(collisionDistance, velocity);
        double collidingTime = 0.39 * (double)(force <= 340.0 ? 1 : 2) - timeToCollision;
        if (collidingTime > 0.0) {
            Location edgeDirection = boundaries.getTargetEdgeDirection().setZ(0.0).getNormalized();
            Location computedDirection = boundaries.getLandingTarget().sub(boundaries.getTakeOffMax()).setZ(0.0).getNormalized();
            Location verticalDirection = new Location(edgeDirection.y, -edgeDirection.x);
            double angleCos = verticalDirection.dot(computedDirection);
            double collisionCoef = 1.0 + collidingTime / 0.39 * (1.0 - angleCos);
            force = Math.min(755.0, force * collisionCoef);
            this.log.log(Level.FINER, "Possible jump collision detected, adjusting power. NEW POWER: {0}, Angle cos: {1}, Colliding time: {2}", new Object[]{force, angleCos, collidingTime});
        }
        return force;
    }

    public Double computeJump(double targetZ, double timeToPassDistance, double jumpAngleCos) {
        if (!this.isJumpable(timeToPassDistance, targetZ)) {
            this.log.log(Level.FINER, "We are not able to jump there! Time: {0} Z: {1}", new Object[]{timeToPassDistance, targetZ});
            return Double.NaN;
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, "Computing jump. Time to pass the distance: {0}", timeToPassDistance);
        }
        Double power = Double.NaN;
        if (this.isSingleJumpable(timeToPassDistance, targetZ)) {
            this.log.log(Level.FINER, "Computing jump. Single jump should suffice.");
            power = this.getSingleJumpPower(targetZ, timeToPassDistance);
        }
        if (power.equals(Double.NaN)) {
            this.log.log(Level.FINER, "Computing jump. Double jump will be needed.");
            power = this.getDoubleJumpPower(targetZ, timeToPassDistance, 0.39);
        }
        return power;
    }

    private double getDistance2D(Location start, Location end, double jumpAngleCos) {
        double distance2d = start.getDistance2D(end);
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, "Computing jump. Distance2D: {0} AngleCos: {1}", new Object[]{distance2d, jumpAngleCos});
        }
        if (jumpAngleCos > 0.0) {
            distance2d = start.getDistance2D(end) / jumpAngleCos;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.log(Level.FINER, "Computing jump. Distance2D after angle correction: {0}", distance2d);
            }
        } else if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, "Computing jump. Jump angle is > 90, no angle correction: {0}", distance2d);
        }
        return distance2d;
    }

    public boolean isJumpable(Location start, Location end, double velocity) {
        if (start == null || end == null) {
            return false;
        }
        if (end.z - start.z > 130.0) {
            return false;
        }
        double distance2d = start.getDistance2D(end);
        return this.isJumpable(distance2d, velocity, end.z - start.z);
    }

    private boolean isJumpable(double distance2d, double velocity, double zDiff) {
        double timeToPassDistance = this.getTimeToPassDistance(distance2d, velocity);
        return this.isJumpable(timeToPassDistance, zDiff);
    }

    private boolean isJumpable(double timeToPassDistance, double zDiff) {
        double computedZDiff = timeToPassDistance < 0.78 ? 130.0 : this.getZDiffForJump(755.0, timeToPassDistance, true, 0.39);
        return computedZDiff >= zDiff;
    }

    private double getTimeToPassDistance(double distance2d, double velocity) {
        if (distance2d < velocity * 0.1) {
            return distance2d / velocity;
        }
        return 0.1 + (distance2d - velocity * 0.1) / (velocity * 1.08959);
    }

    private double getZDiffForJump(double power, double deltaTime, boolean isDoubleJump, double delay) {
        double z = 0.0;
        z += -475.0 * (deltaTime * deltaTime) + Math.min(power, 340.0) * deltaTime;
        if (isDoubleJump) {
            z += ((power - 340.0) * 1.066 + 2.0) * (deltaTime - delay);
        }
        return z;
    }

    private double getSingleJumpPower(double targetZ, double time) {
        double power = (targetZ + 475.0 * time * time) / time;
        if (power > 340.0) {
            return Double.NaN;
        }
        return power;
    }

    private double getDoubleJumpPower(double targetZ, double time, double delay) {
        double power = 0.0;
        if (time < delay) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.log(Level.FINER, "Computing double jump power. Time is lower than delay, postponing result.");
            }
            if ((power = this.getPowerForJumpByZDiff(targetZ)) < 0.0) {
                return power;
            }
            return Double.NaN;
        }
        power = (targetZ + 475.0 * time * time + 20.0 * time - 140.0) / (1.066 * (time - delay));
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, "Computing double jump power. targetZ: {0}, Time: {1}, Delay: {2}, POWER: {3}", new Object[]{targetZ, time, delay, power});
        }
        if (power > 755.0) {
            return Double.NaN;
        }
        return power;
    }

    private Location getNavMeshPoint(Location from, Location direction, double distance) {
        return from.interpolate(direction, distance / from.getDistance2D(direction));
    }

    private boolean isSingleJumpable(double timeToPassDistance, double zDiff) {
        if (zDiff > 60.0) {
            return false;
        }
        if (timeToPassDistance < 0.39) {
            return true;
        }
        double computedZDiff = this.getZDiffForJump(340.0, timeToPassDistance, false, 0.0);
        return computedZDiff >= zDiff;
    }

    public Location getCollisionLocation(JumpBoundaries boundaries) {
        double correctionDistance;
        double koef;
        if (!boundaries.isJumpUp()) {
            return null;
        }
        if (boundaries.getTargetEdgeDirection() == null) {
            return null;
        }
        Location edgeDirection = boundaries.getTargetEdgeDirection().setZ(0.0).getNormalized();
        Location computedDirection = boundaries.getLandingTarget().sub(boundaries.getTakeOffMax()).setZ(0.0).getNormalized();
        Location verticalDirection = new Location(edgeDirection.y, -edgeDirection.x);
        double angleCos = verticalDirection.dot(computedDirection);
        double xAngle = edgeDirection.dot(computedDirection);
        if (Math.abs(xAngle) < Math.cos(1.0471975511965976)) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.log(Level.FINER, "Computing collision. Ignoring collision. Edge to mesh angle cos: {0}", xAngle);
            }
            return null;
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, "Computing collision. Angle cos: {0}", angleCos);
        }
        Location collisionLocation = (koef = (correctionDistance = 140.0 / angleCos) / boundaries.getLandingTarget().getDistance2D(boundaries.getTakeOffMax())) > 1.0 ? boundaries.getTakeOffMax() : boundaries.getLandingTarget().interpolate(boundaries.getTakeOffMax(), koef);
        return collisionLocation;
    }

    public Location getNearestMeshDirection(Location location, Location direction) {
        NavMeshPolygon poly = this.navMesh.getNearestPolygon(location);
        Line2D ray = new Line2D(location.x, location.y, location.x + direction.x * 10000.0, location.y + direction.y * 10000.0);
        int[] polygon = this.navMesh.getPolygon(poly.getPolygonId());
        for (int i = 0; i < polygon.length; ++i) {
            double[] vertex2;
            int v1 = polygon[i];
            int v2 = polygon[i == polygon.length - 1 ? 0 : i + 1];
            double[] vertex1 = this.navMesh.getVertex(v1);
            Line2D edge = new Line2D(vertex1[0], vertex1[1], (vertex2 = this.navMesh.getVertex(v2))[0], vertex2[1]);
            Point2D cross = ray.getIntersection((LinearShape2D)edge);
            if (cross == null || !(cross.x <= Math.max(edge.p1.x, edge.p2.x) && cross.x >= Math.min(edge.p1.x, edge.p2.x)) && !(Math.abs(cross.x - edge.p1.x) < 1.0E-4) || !(cross.x <= Math.max(ray.p1.x, ray.p2.x) && cross.x >= Math.min(ray.p1.x, ray.p2.x)) && !(Math.abs(cross.x - ray.p1.x) < 1.0E-4)) continue;
            Location vertex1Loc = new Location(vertex1);
            Location vertex2Loc = new Location(vertex2);
            return vertex2Loc.sub(vertex1Loc);
        }
        return null;
    }

    public double getCorrectedVelocity(double velocity, boolean isAccelerating) {
        if (!isAccelerating) {
            return velocity;
        }
        return Math.min(439.5, 0.9788 * velocity + 111.0);
    }

    public double getCorrectedAngle(double angleCos, boolean isFirstStep) {
        if (isFirstStep) {
            return angleCos;
        }
        return Math.cos(Math.acos(angleCos) / 2.0);
    }

    private double getPowerForJumpByZDiff(double zDiff) {
        if ((zDiff += 5.0) < 60.0) {
            return 3.87 * zDiff + 111.0;
        }
        return 3.136 * zDiff + 287.0;
    }
}

