/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.LevelGeometry;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.LevelGeometryBSPNode;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.IUT2004ServerProvider;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.UT2004Draw;
import java.awt.Color;
import java.util.logging.Logger;

public class LevelGeometryDraw
extends UT2004Draw {
    private LevelGeometry levelGeometry;

    public LevelGeometryDraw(LevelGeometry levelGeometry, Logger log, IUT2004ServerProvider serverProvider) {
        super(log, serverProvider);
        this.levelGeometry = levelGeometry;
    }

    public boolean draw() {
        if (this.levelGeometry == null || !this.levelGeometry.isLoaded()) {
            return false;
        }
        this.log.info("Drawing LevelGeomtry...");
        for (int[] triangle : this.levelGeometry.triangles) {
            double[][] verts = new double[][]{this.levelGeometry.verts.get(triangle[0]), this.levelGeometry.verts.get(triangle[1]), this.levelGeometry.verts.get(triangle[2])};
            this.drawPolygon(verts);
        }
        this.log.info("LevelGeomtry drawn.");
        return true;
    }

    public void setLevelGeometry(LevelGeometry levelGeometry) {
        this.levelGeometry = levelGeometry;
    }

    public boolean drawBSP() {
        if (this.levelGeometry == null || !this.levelGeometry.isLoaded()) {
            return false;
        }
        this.log.info("Drawing LevelGeomtry BSP...");
        this.drawBSPRecursively(this.levelGeometry.getBSPRoot());
        return true;
    }

    public boolean drawRaycast(LevelGeometry.RaycastResult ray) {
        if (this.levelGeometry == null || !this.levelGeometry.isLoaded()) {
            return false;
        }
        LevelGeometry lg = this.levelGeometry;
        RaycastResultIterator iter = new RaycastResultIterator(ray);
        Color lineColor = ray.hit ? Color.RED : Color.BLUE;
        Color cubeColor = ray.hit ? Color.ORANGE : Color.CYAN;
        while (true) {
            this.drawBSPNodeCube(Color.YELLOW, iter.node);
            this.drawLine(lineColor, iter.from, iter.to);
            this.drawCube(cubeColor, iter.to, 8.0);
            if (!iter.hasNext()) break;
            iter.next();
        }
        if (ray.hit) {
            int[] triangle = lg.triangles.get(ray.hitTriangle);
            this.drawPolygon(cubeColor, (double[][])new double[][]{lg.verts.get(triangle[0]), lg.verts.get(triangle[1]), lg.verts.get(triangle[2])});
        }
        return true;
    }

    private void drawBSPNodeCube(Color color, LevelGeometryBSPNode node) {
        Location v1 = null;
        Location v2 = null;
        Location v3 = null;
        Location v4 = null;
        v1 = new Location(node.minX, node.minY, node.minZ);
        v2 = new Location(node.minX, node.maxY, node.minZ);
        v3 = new Location(node.minX, node.maxY, node.maxZ);
        v4 = new Location(node.minX, node.minY, node.maxZ);
        this.drawPolygon(color, v1, v2, v3, v4);
        v1 = new Location(node.maxX, node.minY, node.minZ);
        v2 = new Location(node.maxX, node.maxY, node.minZ);
        v3 = new Location(node.maxX, node.maxY, node.maxZ);
        v4 = new Location(node.maxX, node.minY, node.maxZ);
        this.drawPolygon(color, v1, v2, v3, v4);
        v1 = new Location(node.minX, node.minY, node.minZ);
        v2 = new Location(node.maxX, node.minY, node.minZ);
        this.drawLine(color, v1, v2);
        v1 = new Location(node.minX, node.maxY, node.minZ);
        v2 = new Location(node.maxX, node.maxY, node.minZ);
        this.drawLine(color, v1, v2);
        v1 = new Location(node.minX, node.maxY, node.maxZ);
        v2 = new Location(node.maxX, node.maxY, node.maxZ);
        this.drawLine(color, v1, v2);
        v1 = new Location(node.minX, node.minY, node.maxZ);
        v2 = new Location(node.maxX, node.minY, node.maxZ);
        this.drawLine(color, v1, v2);
    }

    private void drawBSPRecursively(LevelGeometryBSPNode node) {
        if (node.left == null) {
            return;
        }
        Location v1 = null;
        Location v2 = null;
        Location v3 = null;
        Location v4 = null;
        switch (node.sepDim) {
            case 0: {
                v1 = new Location(node.sepVal, node.minY, node.minZ);
                v2 = new Location(node.sepVal, node.maxY, node.minZ);
                v3 = new Location(node.sepVal, node.maxY, node.maxZ);
                v4 = new Location(node.sepVal, node.minY, node.maxZ);
                break;
            }
            case 1: {
                v1 = new Location(node.minX, node.sepVal, node.minZ);
                v2 = new Location(node.maxX, node.sepVal, node.minZ);
                v3 = new Location(node.maxX, node.sepVal, node.maxZ);
                v4 = new Location(node.minX, node.sepVal, node.maxZ);
                break;
            }
            case 2: {
                v1 = new Location(node.minX, node.minY, node.sepVal);
                v2 = new Location(node.maxX, node.minY, node.sepVal);
                v3 = new Location(node.maxX, node.maxY, node.sepVal);
                v4 = new Location(node.minX, node.maxY, node.sepVal);
            }
        }
        this.drawPolygon(Color.YELLOW, v1, v2, v3, v4);
        this.drawBSPRecursively(node.left);
        this.drawBSPRecursively(node.right);
    }

    private static class RaycastResultIterator {
        private LevelGeometry.RaycastResult result;
        public Location from;
        public Location to;
        public LevelGeometryBSPNode node;
        private int index = 0;

        public RaycastResultIterator(LevelGeometry.RaycastResult result) {
            this.result = result;
            this.node = result.travelledNodes.get(0);
            this.from = result.from;
            this.to = result.travelledNodes.size() == 1 ? (result.hit ? result.hitLocation : result.to) : result.rayPoints.get(0);
        }

        public boolean hasNext() {
            return this.index + 1 < this.result.travelledNodes.size();
        }

        public void next() {
            if (!this.hasNext()) {
                return;
            }
            this.from = this.to;
            ++this.index;
            this.node = this.result.travelledNodes.get(this.index);
            this.to = this.index + 1 == this.result.travelledNodes.size() ? (this.result.hit ? this.result.hitLocation : this.result.to) : this.result.rayPoints.get(this.index);
        }
    }
}

