package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing;

import java.awt.Color;
import java.util.logging.Logger;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DrawStayingDebugLines;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;

public class UT2004Draw {

	protected Logger log;
	
	protected IUT2004ServerProvider serverProvider;

	protected Color defaultColor = Color.WHITE;
	
	protected Location origin = new Location(0,0,0);
	
	protected double scale = 1;
	
	public UT2004Draw(Logger log, IUT2004ServerProvider serverProvider) {
		this.log = log;
		if (log == null) {
			log = new LogCategory("Draw");
		}
		this.serverProvider = serverProvider;
	}
	
	// =====================
	// UT2004 SERVER SHARING
	// =====================
	
	protected UT2004Server getServer() {
		return serverProvider.getServer();
	}
	
	// ============
	// INITIALIZING
	// ============
	
	public void init() {
		serverProvider.getServer();
	}
	
	// ============
	// STATE METHOD
	// ============
	
	public Location getOrigin() {
		return origin;
	}
	
	public void setOrigin(Location location) {
		this.origin = location;
		if (this.origin == null) this.origin = new Location(0,0,0);
	}
	
	public double getScale() {
		return scale;
	}
	
	public void setScale(double scale) {
		this.scale = scale;		
	}
	
	public Color getColor() {
		return defaultColor;
	}
	
	public void setColor(Color color) {
		this.defaultColor = color;
		if (this.defaultColor == null) {
			this.defaultColor = Color.WHITE;
		}
	}
	
	// ===============
	// DRAWING METHODS
	// ===============
	
	public void drawLine(Location from, Location to) {
		drawLine(defaultColor, from, to);
	}
	
	public void drawLine(Color color, Location from, Location to) {
		if (color == null || from == null || to == null) return;
		
		init();
		
		DrawStayingDebugLines cmd = newDrawCommand(color);
		
		cmd.setVectors(getDrawVectors(from, to));
		
		getServer().getAct().act(cmd);
	}
	
	public void drawPolyLine(Location... points) {
		drawPolyLine(defaultColor, points);
	}
	
	public void drawPolyLine(Color color, Location... vertices) {
		if (color == null || vertices == null || vertices.length < 2) return;
			
		init();
		
		DrawStayingDebugLines cmd = newDrawCommand(color);
		
		cmd.setVectors(getDrawPolyLine(vertices));
		
		getServer().getAct().act(cmd);
	}
	
	public void drawPolygon(Location... vertices) {
		drawPolygon(defaultColor, vertices);
	}
	
	public void drawPolygon(Color color, Location... vertices) {
		if (color == null || vertices == null || vertices.length < 3) return;
			
		init();
		
		DrawStayingDebugLines cmd = newDrawCommand(color);
		
		cmd.setVectors(getDrawPolygon(vertices));
		
		getServer().getAct().act(cmd);		
	}
		
	public void clearAll() {
		init();
		
		DrawStayingDebugLines cmd = new DrawStayingDebugLines();
		cmd.setClearAll(true);
		
		getServer().getAct().act(cmd);		
	}
	
	// =============
	// PRIVATE STUFF
	// =============
	
	private Location adjustLocation(Location location) {
		return location.scale(scale).add(origin);
	}
	
	private String getDrawVector(Location point) {
		if (point == null) return "";
		point = adjustLocation(point);
		int x = (int)Math.round(point.x);
		int y = (int)Math.round(point.y);
		int z = (int)Math.round(point.z);
		return x + "," + y + "," + z;
	}
	
	private void writeDrawVector(StringBuffer sb, Location point) {
		if (point == null) return;
		point = adjustLocation(point);
		int x = (int)Math.round(point.x);
		int y = (int)Math.round(point.y);
		int z = (int)Math.round(point.z);
		sb.append(x);
		sb.append(",");
		sb.append(y);
		sb.append(",");
		sb.append(z);
	}
	
	private String getDrawVectors(Location... points) {
		if (points == null) return "";
		StringBuffer sb = new StringBuffer();
		boolean first = true;
		for (Location point : points) {
			if (first) first = false;
			else sb.append(";");
			writeDrawVector(sb, point);			
		}
		return sb.toString();
	}
	
	private String getDrawPolyLine(Location... points) {
		if (points == null || points.length == 0) return "";
		
		StringBuffer sb = new StringBuffer();
		boolean first = true;
		
		Location point = points[0];
		
		for (int i = 1; i < points.length; ++i) {
			if (first) first = false;
			else sb.append(";");
			writeDrawVector(sb, point);
			sb.append(";");
			writeDrawVector(sb, points[i]);
			point = points[i];
		}
		
		return sb.toString();
	}
	
	private String getDrawPolygon(Location... points) {
		if (points == null || points.length < 2) return "";
		
		StringBuffer sb = new StringBuffer();
		boolean first = true;
		
		Location point = points[0];
		
		for (int i = 1; i < points.length; ++i) {
			if (first) first = false;
			else sb.append(";");
			writeDrawVector(sb, point);
			sb.append(";");
			writeDrawVector(sb, points[i]);
			point = points[i];
		}
		
		sb.append(";");
		writeDrawVector(sb, points[points.length-1]);
		sb.append(";");
		writeDrawVector(sb, points[0]);
		
		return sb.toString();
	}
	
	private DrawStayingDebugLines newDrawCommand() {
		return newDrawCommand(defaultColor);
	}
	
	private DrawStayingDebugLines newDrawCommand(Color color) {
		DrawStayingDebugLines cmd = new DrawStayingDebugLines();
		
		cmd.setColor(new Location(defaultColor.getRed(), defaultColor.getGreen(), defaultColor.getBlue()));
		cmd.setClearAll(false);
		
		return cmd;
	}
		
}
