/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.multi.agent.ITeamId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedPropertyUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.BooleanProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.IntegerProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.LocationProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.PropertyId;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.RotationProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.VelocityProperty;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.VehicleShared;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.property.UnrealIdProperty;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class VehicleSharedImpl
extends VehicleShared {
    protected HashMap<PropertyId, ISharedProperty> propertyMap = new HashMap(8);
    protected UnrealId Id = null;
    protected RotationProperty myRotation = null;
    protected LocationProperty myLocation = null;
    protected VelocityProperty myVelocity = null;
    protected IntegerProperty myTeam = null;
    protected IntegerProperty myHealth = null;
    protected IntegerProperty myArmor = null;
    protected UnrealIdProperty myDriver = null;
    protected BooleanProperty myTeamLocked = null;

    public VehicleSharedImpl(VehicleSharedImpl source) {
        this.Id = source.getId();
        this.myRotation = source.myRotation;
        this.myLocation = source.myLocation;
        this.myVelocity = source.myVelocity;
        this.myTeam = source.myTeam;
        this.myHealth = source.myHealth;
        this.myArmor = source.myArmor;
        this.myDriver = source.myDriver;
        this.myTeamLocked = source.myTeamLocked;
    }

    public VehicleSharedImpl(WorldObjectId objectId, Collection<ISharedProperty> properties) {
        this.Id = (UnrealId)objectId;
        NullCheck.check((Object)this.Id, (String)"objectId");
        if (properties.size() != 8) {
            throw new PogamutException("Not enough properties passed to the constructor.", VehicleSharedImpl.class);
        }
        for (ISharedProperty property : properties) {
            PropertyId pId = property.getPropertyId();
            if (!objectId.equals((Object)property.getObjectId())) {
                throw new PogamutException("Trying to create a VehicleSharedImpl with different WorldObjectId properties : " + this.Id.getStringId() + " / " + property.getObjectId().getStringId(), (Object)this);
            }
            if (!VehicleShared.SharedPropertyTokens.contains(pId.getPropertyToken())) {
                throw new PogamutException("Trying to create a VehicleSharedImpl with invalid property (invalid property token): " + this.Id.getStringId() + " / " + property.getPropertyId().getPropertyToken().getToken(), (Object)this);
            }
            this.propertyMap.put(property.getPropertyId(), property);
            if (pId.getPropertyToken().getToken().equals("Rotation")) {
                this.myRotation = (RotationProperty)property;
            }
            if (pId.getPropertyToken().getToken().equals("Location")) {
                this.myLocation = (LocationProperty)property;
            }
            if (pId.getPropertyToken().getToken().equals("Velocity")) {
                this.myVelocity = (VelocityProperty)property;
            }
            if (pId.getPropertyToken().getToken().equals("Team")) {
                this.myTeam = (IntegerProperty)property;
            }
            if (pId.getPropertyToken().getToken().equals("Health")) {
                this.myHealth = (IntegerProperty)property;
            }
            if (pId.getPropertyToken().getToken().equals("Armor")) {
                this.myArmor = (IntegerProperty)property;
            }
            if (pId.getPropertyToken().getToken().equals("Driver")) {
                this.myDriver = (UnrealIdProperty)property;
            }
            if (!pId.getPropertyToken().getToken().equals("TeamLocked")) continue;
            this.myTeamLocked = (BooleanProperty)property;
        }
    }

    @Override
    public void setSimTime(long SimTime) {
        super.setSimTime(SimTime);
    }

    @Override
    public VehicleSharedImpl clone() {
        return new VehicleSharedImpl(this);
    }

    public ISharedProperty getProperty(PropertyId id) {
        return this.propertyMap.get(id);
    }

    public Map<PropertyId, ISharedProperty> getProperties() {
        return this.propertyMap;
    }

    @Override
    public UnrealId getId() {
        return this.Id;
    }

    @Override
    public Rotation getRotation() {
        return (Rotation)this.myRotation.getValue();
    }

    @Override
    public Location getLocation() {
        return (Location)this.myLocation.getValue();
    }

    @Override
    public Velocity getVelocity() {
        return (Velocity)this.myVelocity.getValue();
    }

    @Override
    public Integer getTeam() {
        return (Integer)this.myTeam.getValue();
    }

    @Override
    public Integer getHealth() {
        return (Integer)this.myHealth.getValue();
    }

    @Override
    public Integer getArmor() {
        return (Integer)this.myArmor.getValue();
    }

    @Override
    public UnrealId getDriver() {
        return (UnrealId)this.myDriver.getValue();
    }

    @Override
    public boolean isTeamLocked() {
        return (Boolean)this.myTeamLocked.getValue();
    }

    @Override
    public String toString() {
        return super.toString() + "[" + "Id = " + String.valueOf(this.getId()) + " | " + "Rotation = " + String.valueOf(this.getRotation()) + " | " + "Location = " + String.valueOf(this.getLocation()) + " | " + "Velocity = " + String.valueOf(this.getVelocity()) + " | " + "Team = " + String.valueOf(this.getTeam()) + " | " + "Health = " + String.valueOf(this.getHealth()) + " | " + "Armor = " + String.valueOf(this.getArmor()) + " | " + "Driver = " + String.valueOf(this.getDriver()) + " | " + "TeamLocked = " + String.valueOf(this.isTeamLocked()) + " | " + "]";
    }

    @Override
    public String toHtmlString() {
        return super.toString() + "[<br/>" + "<b>Id</b> = " + String.valueOf(this.getId()) + " <br/> " + "<b>Rotation</b> = " + String.valueOf(this.getRotation()) + " <br/> " + "<b>Location</b> = " + String.valueOf(this.getLocation()) + " <br/> " + "<b>Velocity</b> = " + String.valueOf(this.getVelocity()) + " <br/> " + "<b>Team</b> = " + String.valueOf(this.getTeam()) + " <br/> " + "<b>Health</b> = " + String.valueOf(this.getHealth()) + " <br/> " + "<b>Armor</b> = " + String.valueOf(this.getArmor()) + " <br/> " + "<b>Driver</b> = " + String.valueOf(this.getDriver()) + " <br/> " + "<b>TeamLocked</b> = " + String.valueOf(this.isTeamLocked()) + " <br/> " + "<br/>]";
    }

    public static class VehicleSharedUpdate
    implements ISharedWorldObjectUpdatedEvent {
        private VehicleShared object;
        private long time;
        private ITeamId teamId;

        public VehicleSharedUpdate(VehicleShared data, long time, ITeamId teamId) {
            this.object = data;
            this.time = time;
            this.teamId = teamId;
        }

        public long getSimTime() {
            return this.time;
        }

        public WorldObjectId getId() {
            return this.object.getId();
        }

        public ITeamId getTeamId() {
            return this.teamId;
        }

        public Class getCompositeObjectClass() {
            return this.object.getCompositeClass();
        }

        public Collection<ISharedPropertyUpdatedEvent> getPropertyEvents() {
            LinkedList<ISharedPropertyUpdatedEvent> events = new LinkedList<ISharedPropertyUpdatedEvent>();
            for (ISharedProperty property : this.object.getProperties().values()) {
                if (property == null) continue;
                events.push(property.createUpdateEvent(this.time, this.teamId));
            }
            return events;
        }
    }
}

