/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot.impl.vials;

import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UT2004ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.parser.UT2004Parser;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004SyncLockableWorldView;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.collections.MyCollections;
import java.io.File;
import java.util.logging.Level;

public class HealthVialsBot
extends UT2004BotModuleController<UT2004Bot> {
    Item target;
    boolean onceExecuted;

    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        super.botInitialized(gameInfo, currentConfig, init);
        this.bot.getLogger().addDefaultFileHandler(new File("vials-bot.log"));
        this.bot.getLogger().getCategory(UT2004Parser.COMPONENT_ID.getToken()).setLevel(Level.ALL);
        this.bot.getLogger().getCategory(UT2004SyncLockableWorldView.COMPONENT_ID.getToken()).setLevel(Level.ALL);
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004TimeStuckDetector(this.bot, 3000.0, 10000.0));
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004PositionStuckDetector(this.bot));
    }

    public void logic() {
        if (this.target == null) {
            this.target = (Item)MyCollections.getRandom(this.items.getSpawnedItems((ItemType)UT2004ItemType.MINI_HEALTH_PACK).values());
        }
        if (this.target == null) {
            this.log.warning("NO MORE SPAWNED VIALS TO RUN TO!");
            return;
        }
        boolean visible = this.target.isVisible();
        boolean spawned = this.items.getSpawnedItems((ItemType)UT2004ItemType.MINI_HEALTH_PACK).containsKey(this.target.getId());
        this.log.warning("Target:         " + this.target);
        this.log.warning("Target ID:      " + this.target.getId().getStringId());
        this.log.warning("Target visible: " + visible);
        this.log.warning("Target spawned: " + spawned);
        if (this.pathExecutor.isExecuting()) {
            return;
        }
        if (visible || spawned) {
            this.pathExecutor.followPath(this.pathPlanner.computePath((Object)this.bot.getLocation(), (Object)this.target));
        } else {
            this.log.warning("TARGET IS NEITHER VISIBLE NOR SPAWNED! GOING FOR ANOTHER VIAL!");
            this.target = null;
            this.onceExecuted = false;
            this.logic();
        }
    }

    public static void main(String[] args) {
        new UT2004BotRunner(HealthVialsBot.class, "HealthVialsBot").setMain(true).startAgents(1);
    }
}

