package cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric;

import java.util.UUID;
import java.util.concurrent.Future;
import java.util.logging.Logger;

import javax.vecmath.Vector3d;

import cz.cuni.amis.pogamut.base.agent.module.SensomotoricModule;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRayMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;

public class RaycastingBSP extends SensomotoricModule<UT2004Bot> {
	
	int counter = 0;
	private String idSuffix;
	
	private IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> selfListener = new IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>>() {

		@Override
		public void notify(WorldObjectUpdatedEvent<Self> event) {
			selfUpdate(event.getObject());
		}
		
	};

    public RaycastingBSP(UT2004Bot bot) {
        this(bot, null);
    }
    
    
	public RaycastingBSP(UT2004Bot bot, Logger log) {
        super(bot, log);
        
        idSuffix = "_" + bot.getName() + UUID.randomUUID().toString();
        
        bot.getWorldView().addObjectListener(Self.class, WorldObjectUpdatedEvent.class, selfListener);
    }
    
    /**
     * Whether we have BSP data for raycasting.
     * @return
     */
    public boolean isUsable() {
    	return false;
    }

    /**
     * Deletes all previous rays and makes this instance ready for setting up
     * new rays.
     */
	public void clear() {
	}

	public Future<AutoTraceRay> createRay(Vector3d direction, int length, boolean floorCorrection) {
		String id = counter++ + idSuffix;
		return createRay(id, direction, length, floorCorrection);
	}

	public Future<AutoTraceRay> createRay(String id, Vector3d direction, int length, boolean floorCorrection) {
		// TODO
		UnrealId unrealId = UnrealId.get(id);
		return null;
	}
	
	protected void selfUpdate(Self self) {
		// RECOMPUTE AutoTraceRay(s)
		
		
//		AutoTraceRay ray = new AutoTraceRayMessage(
//			// unrealId ray z createRay()
//			// Location From == self.getLocation()  
//			// Location To   == end of ray
//			// boolean FastTrace == false
//			// boolean FloorCorrection
//			// boolean Result
//			// Vector3d HitNormal
//			// Location HitLocation
//			// boolean TraceActors == false
//			// UnrealId HitId == null
//		);
//		
//		agent.getWorldView().notify(ray);
	}


}
