/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AdrenalineGained;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotDamaged;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Bumped;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FallEdge;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.HearNoise;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.HearPickup;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.IncomingProjectile;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerDamaged;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.WallCollision;
import cz.cuni.amis.utils.NullCheck;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.vecmath.Vector3d;

public class Senses
extends SensorModule<UT2004Bot> {
    public static final double SENSE_THRESHOLD = 0.5;
    Bumped lastBumped = null;
    double lastBumpedTime = -1.0;
    boolean lastBumpedFlag = false;
    WallCollision lastWallCollision = null;
    double lastWallCollisionTime = -1.0;
    boolean lastWallCollisionFlag = false;
    FallEdge lastFallEdge = null;
    double lastFallEdgeTime = -1.0;
    boolean lastFallEdgeFlag = false;
    HearNoise lastHearNoise = null;
    double lastHearNoiseTime = -1.0;
    boolean lastHearNoiseFlag = false;
    HearPickup lastHearPickup = null;
    double lastHearPickupTime = -1.0;
    boolean lastHearPickupFlag = false;
    BotDamaged lastBotDamaged = null;
    double lastBotDamagedTime = -1.0;
    boolean lastBotDamagedFlag = false;
    BotDamaged lastBotShot = null;
    double lastBotShotTime = -1.0;
    boolean lastBotShotFlag = false;
    IncomingProjectile lastIncomingProjectile = null;
    double lastIncomingProjectileTime = -1.0;
    boolean lastIncomingProjectileFlag = false;
    PlayerDamaged lastPlayerDamaged = null;
    double lastPlayerDamagedTime = -1.0;
    boolean lastPlayerDamagedFlag = false;
    PlayerDamaged lastPlayerShot = null;
    double lastPlayerShotTime = -1.0;
    boolean lastPlayerShotFlag = false;
    ItemPickedUp lastItemPickedUp = null;
    double lastItemPickedUpTime = -1.0;
    boolean lastItemPickedUpFlag = false;
    private BeginMessage previousBeginMessage = null;
    private BeginMessage lastBeginMessage = null;
    private Map<UnrealId, Entry<PlayerKilled>> playerKilled = new HashMap<UnrealId, Entry<PlayerKilled>>();
    private boolean playerKilledGlobalFlag = false;
    AdrenalineGained lastAdrenalineGained = null;
    double lastAdrenalineGainedTime = -1.0;
    boolean lastAdrenalineGainedFlag = false;
    BotKilled lastBotKilled = null;
    double lastBotKilledTime = -1.0;
    boolean lastBotKilledFlag = false;
    BumpedListener bumpedListener;
    WallCollisionListener wallCollisitonListener;
    FallEdgeListener fallEdgeListener;
    HearNoiseListener hearNoiseListener;
    HearPickupListener hearPickupListener;
    BotDamagedListener botDamagedListener;
    IncomingProjectileListener incomingProjectileListener;
    PlayerDamagedListener playerDamagedListener;
    PlayerKilledListener playerKilledListener;
    AdrenalineGainedListener adrenalineGainedListener;
    BotKilledListener botKilledListener;
    BeginMessageListener beginMessageListener;
    ItemPickedUpListener itemPickedUpListener;
    protected AgentInfo agentInfo;
    private Players players;

    public boolean isCollidingOnce() {
        if (!this.lastWallCollisionFlag) {
            return false;
        }
        boolean col = this.agentInfo.getLocation().getDistance(this.lastWallCollision.getLocation()) < 100.0;
        this.lastWallCollisionFlag = false;
        return col;
    }

    public boolean isColliding() {
        if (this.lastWallCollision == null) {
            return false;
        }
        return this.agentInfo.getTime() - this.lastWallCollisionTime < 0.5 && this.agentInfo.getLocation().getDistance(this.lastWallCollision.getLocation()) < 100.0;
    }

    public Location getCollisionLocation() {
        if (this.lastWallCollision == null) {
            return null;
        }
        return this.lastWallCollision.getLocation();
    }

    public Vector3d getCollisionNormal() {
        if (this.lastWallCollision == null) {
            return null;
        }
        return this.lastWallCollision.getNormal();
    }

    public boolean isBumping() {
        if (this.lastBumped == null) {
            return false;
        }
        return this.agentInfo.getTime() - this.lastBumpedTime < 0.5 && this.agentInfo.getLocation().getDistance(this.lastBumped.getLocation()) < 100.0;
    }

    public boolean isBumpingOnce() {
        if (!this.lastBumpedFlag) {
            return false;
        }
        boolean result = this.isBumping();
        this.lastBumpedFlag = false;
        return result;
    }

    public boolean isBumpingPlayer() {
        if (!this.isBumping()) {
            return false;
        }
        return this.players.getPlayer(this.lastBumped.getId()) != null;
    }

    public boolean isBumpingPlayerOnce() {
        if (!this.lastBumpedFlag) {
            return false;
        }
        boolean result = this.isBumpingPlayer();
        this.lastBumpedFlag = false;
        return result;
    }

    public Player getBumpingPlayer() {
        if (this.lastBumped == null) {
            return null;
        }
        return this.players.getPlayer(this.lastBumped.getId());
    }

    public Location getBumpLocation() {
        if (this.lastBumped == null) {
            return null;
        }
        return this.lastBumped.getLocation();
    }

    public boolean isFallEdge() {
        if (this.lastFallEdge == null) {
            return false;
        }
        return this.agentInfo.getTime() - this.lastFallEdgeTime < 0.5 && this.agentInfo.getLocation().getDistance(this.lastFallEdge.getLocation()) < 100.0;
    }

    public boolean isFallEdgeOnce() {
        if (!this.lastFallEdgeFlag) {
            return false;
        }
        boolean result = this.isFallEdge();
        this.lastFallEdgeFlag = false;
        return result;
    }

    public boolean isHearingNoise() {
        if (this.lastHearNoise == null) {
            return false;
        }
        return this.agentInfo.getTime() - this.lastHearNoiseTime < 0.5;
    }

    public boolean isHearingNoiseOnce() {
        if (!this.lastHearNoiseFlag) {
            return false;
        }
        boolean result = this.isHearingNoise();
        this.lastHearNoiseFlag = false;
        return result;
    }

    public Rotation getNoiseRotation() {
        if (this.lastHearNoise == null) {
            return null;
        }
        return this.lastHearNoise.getRotation();
    }

    public UnrealId getNoiseSource() {
        if (this.lastHearNoise == null) {
            return null;
        }
        return this.lastHearNoise.getSource();
    }

    public String getNoiseType() {
        if (this.lastHearNoise == null) {
            return null;
        }
        return this.lastHearNoise.getType();
    }

    public boolean isHearingPickup() {
        if (this.lastHearPickup == null) {
            return false;
        }
        return this.agentInfo.getTime() - this.lastHearPickupTime < 0.5;
    }

    public boolean isHearingPickupOnce() {
        if (!this.lastHearPickupFlag) {
            return false;
        }
        boolean result = this.isHearingPickup();
        this.lastHearPickupFlag = false;
        return result;
    }

    public Rotation getPickupNoiseRotation() {
        if (this.lastHearPickup == null) {
            return null;
        }
        return this.lastHearPickup.getRotation();
    }

    public UnrealId getPickupNoiseSource() {
        if (this.lastHearPickup == null) {
            return null;
        }
        return this.lastHearPickup.getSource();
    }

    public String getPickupNoiseType() {
        if (this.lastHearPickup == null) {
            return null;
        }
        return this.lastHearPickup.getType();
    }

    public boolean isBeingDamaged() {
        if (this.lastBotDamaged == null) {
            return false;
        }
        return this.agentInfo.getTime() - this.lastBotDamagedTime < 0.5;
    }

    public boolean isBeingDamagedOnce() {
        if (!this.isBeingDamaged()) {
            return false;
        }
        if (!this.lastBotDamagedFlag) {
            return false;
        }
        this.lastBotDamagedFlag = false;
        return true;
    }

    public BotDamaged getLastDamage() {
        return this.lastBotDamaged;
    }

    public boolean isShot() {
        if (this.lastBotShot == null) {
            return false;
        }
        return this.agentInfo.getTime() - this.lastBotShotTime < 0.5;
    }

    public boolean isShotOnce() {
        if (!this.isShot()) {
            return false;
        }
        if (!this.lastBotShotFlag) {
            return false;
        }
        this.lastBotShotFlag = false;
        return true;
    }

    public BotDamaged getLastShot() {
        return this.lastBotShot;
    }

    public boolean seeIncomingProjectile() {
        if (this.lastIncomingProjectile == null) {
            return false;
        }
        return this.agentInfo.getTime() - this.lastIncomingProjectileTime < 0.5;
    }

    public boolean seeIncomingProjectileOnce() {
        if (!this.seeIncomingProjectile()) {
            return false;
        }
        if (!this.lastIncomingProjectileFlag) {
            return false;
        }
        this.lastIncomingProjectileFlag = false;
        return true;
    }

    public IncomingProjectile getLastIncomingProjectile() {
        return this.lastIncomingProjectile;
    }

    public boolean isCausingDamage() {
        if (this.lastPlayerDamaged == null) {
            return false;
        }
        return this.agentInfo.getTime() - this.lastPlayerDamagedTime < 0.5;
    }

    public boolean isCausingDamageOnce() {
        if (!this.isCausingDamage()) {
            return false;
        }
        if (!this.lastPlayerDamagedFlag) {
            return false;
        }
        this.lastPlayerDamagedFlag = false;
        return true;
    }

    public PlayerDamaged getLastCausedDamage() {
        return this.lastPlayerDamaged;
    }

    public boolean isHitPlayer() {
        if (this.lastPlayerShot == null) {
            return false;
        }
        return this.agentInfo.getTime() - this.lastPlayerShotTime < 0.5;
    }

    public boolean isHitPlayerOnce() {
        if (!this.isHitPlayer()) {
            return false;
        }
        if (!this.lastPlayerShotFlag) {
            return false;
        }
        this.lastPlayerShotFlag = false;
        return true;
    }

    public PlayerDamaged getLastHitPlayer() {
        return this.lastPlayerShot;
    }

    public boolean isPlayerKilled() {
        for (UnrealId id : this.playerKilled.keySet()) {
            if (!this.isPlayerKilled(id)) continue;
            return true;
        }
        return false;
    }

    public boolean isPlayerKilledOnce() {
        if (!this.playerKilledGlobalFlag) {
            return false;
        }
        if (!this.isPlayerKilled()) {
            return false;
        }
        this.playerKilledGlobalFlag = false;
        return true;
    }

    public boolean isPlayerKilled(UnrealId playerId) {
        return this.playerKilled.get(playerId) != null && this.agentInfo.getTime() - ((Entry)this.playerKilled.get(playerId)).time < 0.5;
    }

    public boolean isPlayerKilled(Player player) {
        return this.isPlayerKilled(player.getId());
    }

    public boolean isPlayerKilledOnce(UnrealId playerId) {
        if (!this.isPlayerKilled(playerId)) {
            return false;
        }
        if (((Entry)this.playerKilled.get(playerId)).queried) {
            return false;
        }
        ((Entry)this.playerKilled.get(playerId)).queried = true;
        return true;
    }

    public boolean isPlayerKilledOnce(Player player) {
        return this.isPlayerKilledOnce(player.getId());
    }

    public PlayerKilled getPlayerKilled(UnrealId playerId) {
        if (this.playerKilled.get(playerId) == null) {
            return null;
        }
        return (PlayerKilled)((Entry)this.playerKilled.get(playerId)).event;
    }

    public PlayerKilled getPlayerKilled(Player player) {
        return this.getPlayerKilled(player.getId());
    }

    public boolean isAdrenalineGained() {
        return this.lastAdrenalineGained != null && this.agentInfo.getTime() - this.lastAdrenalineGainedTime < 0.5;
    }

    public boolean isAdrenalineGainedOnce() {
        if (!this.lastAdrenalineGainedFlag) {
            return false;
        }
        if (!this.isAdrenalineGained()) {
            return false;
        }
        this.lastAdrenalineGainedFlag = false;
        return true;
    }

    public boolean hasDied() {
        return this.lastBotKilled != null && this.agentInfo.getTime() - this.lastBotKilledTime < 0.5;
    }

    public boolean hasDiedOnce() {
        if (!this.lastBotKilledFlag) {
            return false;
        }
        if (!this.hasDied()) {
            return false;
        }
        this.lastBotKilledFlag = false;
        return true;
    }

    public BotKilled getBotDeath() {
        return this.lastBotKilled;
    }

    public boolean isItemPickedUp() {
        return this.lastItemPickedUp != null && this.agentInfo.getTime() - this.lastItemPickedUpTime < 0.5;
    }

    public boolean isItemPickedUpOnce() {
        if (!this.lastItemPickedUpFlag) {
            return false;
        }
        if (!this.isItemPickedUp()) {
            return false;
        }
        this.lastItemPickedUpFlag = false;
        return true;
    }

    public ItemPickedUp getItemPickedUp() {
        return this.lastItemPickedUp;
    }

    public Double getTimeDelta() {
        if (this.previousBeginMessage == null) {
            return null;
        }
        return this.lastBeginMessage.getTime() - this.previousBeginMessage.getTime();
    }

    public Senses(UT2004Bot bot) {
        this(bot, new AgentInfo(bot), new Players(bot), null);
    }

    public Senses(UT2004Bot bot, AgentInfo agentInfo, Players players) {
        this(bot, agentInfo, players, null);
    }

    public Senses(UT2004Bot bot, AgentInfo agentInfo, Players players, Logger log) {
        super((IObservingAgent)bot, log);
        this.agentInfo = agentInfo;
        NullCheck.check((Object)((Object)this.agentInfo), (String)"agentInfo");
        this.players = players;
        NullCheck.check((Object)((Object)this.players), (String)"players");
        this.bumpedListener = new BumpedListener(this.worldView);
        this.wallCollisitonListener = new WallCollisionListener(this.worldView);
        this.fallEdgeListener = new FallEdgeListener(this.worldView);
        this.hearNoiseListener = new HearNoiseListener(this.worldView);
        this.hearPickupListener = new HearPickupListener(this.worldView);
        this.botDamagedListener = new BotDamagedListener(this.worldView);
        this.incomingProjectileListener = new IncomingProjectileListener(this.worldView);
        this.playerDamagedListener = new PlayerDamagedListener(this.worldView);
        this.playerKilledListener = new PlayerKilledListener(this.worldView);
        this.adrenalineGainedListener = new AdrenalineGainedListener(this.worldView);
        this.botKilledListener = new BotKilledListener(this.worldView);
        this.itemPickedUpListener = new ItemPickedUpListener(this.worldView);
        this.beginMessageListener = new BeginMessageListener(this.worldView);
        this.cleanUp();
    }

    protected void cleanUp() {
        super.cleanUp();
        this.lastAdrenalineGained = null;
        this.lastAdrenalineGainedFlag = false;
        this.lastAdrenalineGainedTime = -1.0;
        this.lastBotDamaged = null;
        this.lastBotDamagedFlag = false;
        this.lastBotDamagedTime = -1.0;
        this.lastBotKilled = null;
        this.lastBotKilledFlag = false;
        this.lastBotKilledTime = -1.0;
        this.lastBotShot = null;
        this.lastBotShotFlag = false;
        this.lastBotShotTime = -1.0;
        this.lastBumped = null;
        this.lastBumpedFlag = false;
        this.lastBumpedTime = -1.0;
        this.lastFallEdge = null;
        this.lastFallEdgeFlag = false;
        this.lastFallEdgeTime = -1.0;
        this.lastHearNoise = null;
        this.lastHearNoiseFlag = false;
        this.lastHearNoiseTime = -1.0;
        this.lastHearPickup = null;
        this.lastHearPickupFlag = false;
        this.lastHearPickupTime = -1.0;
        this.lastIncomingProjectile = null;
        this.lastIncomingProjectileFlag = false;
        this.lastIncomingProjectileTime = -1.0;
        this.lastPlayerDamaged = null;
        this.lastPlayerDamagedFlag = false;
        this.lastPlayerDamagedTime = -1.0;
        this.lastPlayerShot = null;
        this.lastPlayerShotFlag = false;
        this.lastPlayerShotTime = -1.0;
        this.lastWallCollision = null;
        this.lastWallCollisionFlag = false;
        this.lastWallCollisionTime = -1.0;
    }

    private class ItemPickedUpListener
    implements IWorldEventListener<ItemPickedUp> {
        public void notify(ItemPickedUp event) {
            Senses.this.lastItemPickedUp = event;
            Senses.this.lastItemPickedUpFlag = true;
            Senses.this.lastItemPickedUpTime = Senses.this.agentInfo.getTime();
        }

        public ItemPickedUpListener(IWorldView worldView) {
            worldView.addEventListener(ItemPickedUp.class, (IWorldEventListener)this);
        }
    }

    private class BeginMessageListener
    implements IWorldEventListener<BeginMessage> {
        public void notify(BeginMessage event) {
            Senses.this.previousBeginMessage = Senses.this.lastBeginMessage;
            Senses.this.lastBeginMessage = event;
        }

        public BeginMessageListener(IWorldView worldView) {
            worldView.addEventListener(BeginMessage.class, (IWorldEventListener)this);
        }
    }

    private class BotKilledListener
    implements IWorldEventListener<BotKilled> {
        public void notify(BotKilled event) {
            Senses.this.lastBotKilled = event;
            Senses.this.lastBotKilledFlag = true;
            Senses.this.lastBotKilledTime = Senses.this.agentInfo.getTime();
        }

        public BotKilledListener(IWorldView worldView) {
            worldView.addEventListener(BotKilled.class, (IWorldEventListener)this);
        }
    }

    private class AdrenalineGainedListener
    implements IWorldEventListener<AdrenalineGained> {
        public void notify(AdrenalineGained event) {
            Senses.this.lastAdrenalineGained = event;
            Senses.this.lastAdrenalineGainedFlag = true;
            Senses.this.lastAdrenalineGainedTime = Senses.this.agentInfo.getTime();
        }

        public AdrenalineGainedListener(IWorldView worldView) {
            worldView.addEventListener(AdrenalineGained.class, (IWorldEventListener)this);
        }
    }

    private class PlayerKilledListener
    implements IWorldEventListener<PlayerKilled> {
        public void notify(PlayerKilled event) {
            if (event.getId() == null) {
                return;
            }
            Senses.this.playerKilled.put(event.getId(), new Entry(Senses.this, (InfoMessage)event));
            Senses.this.playerKilledGlobalFlag = true;
        }

        public PlayerKilledListener(IWorldView worldView) {
            worldView.addEventListener(PlayerKilled.class, (IWorldEventListener)this);
        }
    }

    private class PlayerDamagedListener
    implements IWorldEventListener<PlayerDamaged> {
        public void notify(PlayerDamaged event) {
            Senses.this.lastPlayerDamaged = event;
            Senses.this.lastPlayerDamagedTime = Senses.this.agentInfo.getTime();
            Senses.this.lastPlayerDamagedFlag = true;
            if (Senses.this.lastPlayerDamaged.isBulletHit()) {
                Senses.this.lastPlayerShot = event;
                Senses.this.lastPlayerShotTime = Senses.this.agentInfo.getTime();
                Senses.this.lastPlayerShotFlag = true;
            }
        }

        public PlayerDamagedListener(IWorldView worldView) {
            worldView.addEventListener(PlayerDamaged.class, (IWorldEventListener)this);
        }
    }

    private class IncomingProjectileListener
    implements IWorldObjectEventListener<IncomingProjectile, IWorldObjectEvent<IncomingProjectile>> {
        public void notify(IWorldObjectEvent<IncomingProjectile> event) {
            Senses.this.lastIncomingProjectile = (IncomingProjectile)event.getObject();
            Senses.this.lastIncomingProjectileTime = Senses.this.agentInfo.getTime();
            Senses.this.lastIncomingProjectileFlag = true;
        }

        public IncomingProjectileListener(IWorldView worldView) {
            worldView.addObjectListener(IncomingProjectile.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }
    }

    private class BotDamagedListener
    implements IWorldEventListener<BotDamaged> {
        public void notify(BotDamaged event) {
            Senses.this.lastBotDamaged = event;
            Senses.this.lastBotDamagedTime = Senses.this.agentInfo.getTime();
            Senses.this.lastBotDamagedFlag = true;
            if (Senses.this.lastBotDamaged.isBulletHit()) {
                Senses.this.lastBotShot = event;
                Senses.this.lastBotShotTime = Senses.this.agentInfo.getTime();
                Senses.this.lastBotShotFlag = true;
            }
        }

        public BotDamagedListener(IWorldView worldView) {
            worldView.addEventListener(BotDamaged.class, (IWorldEventListener)this);
        }
    }

    private class HearPickupListener
    implements IWorldEventListener<HearPickup> {
        public void notify(HearPickup event) {
            Senses.this.lastHearPickup = event;
            Senses.this.lastHearPickupTime = Senses.this.agentInfo.getTime();
            Senses.this.lastHearPickupFlag = true;
        }

        public HearPickupListener(IWorldView worldView) {
            worldView.addEventListener(HearPickup.class, (IWorldEventListener)this);
        }
    }

    private class HearNoiseListener
    implements IWorldEventListener<HearNoise> {
        public void notify(HearNoise event) {
            Senses.this.lastHearNoise = event;
            Senses.this.lastHearNoiseTime = Senses.this.agentInfo.getTime();
            Senses.this.lastHearNoiseFlag = true;
        }

        public HearNoiseListener(IWorldView worldView) {
            worldView.addEventListener(HearNoise.class, (IWorldEventListener)this);
        }
    }

    private class FallEdgeListener
    implements IWorldEventListener<FallEdge> {
        public void notify(FallEdge event) {
            Senses.this.lastFallEdge = event;
            Senses.this.lastFallEdgeTime = Senses.this.agentInfo.getTime();
            Senses.this.lastFallEdgeFlag = true;
        }

        public FallEdgeListener(IWorldView worldView) {
            worldView.addEventListener(FallEdge.class, (IWorldEventListener)this);
        }
    }

    private class WallCollisionListener
    implements IWorldEventListener<WallCollision> {
        public void notify(WallCollision event) {
            Senses.this.lastWallCollision = event;
            Senses.this.lastWallCollisionTime = Senses.this.agentInfo.getTime();
            Senses.this.lastWallCollisionFlag = true;
        }

        public WallCollisionListener(IWorldView worldView) {
            worldView.addEventListener(WallCollision.class, (IWorldEventListener)this);
        }
    }

    private class BumpedListener
    implements IWorldEventListener<Bumped> {
        public void notify(Bumped event) {
            Senses.this.lastBumped = event;
            Senses.this.lastBumpedTime = Senses.this.agentInfo.getTime();
            Senses.this.lastBumpedFlag = true;
        }

        public BumpedListener(IWorldView worldView) {
            worldView.addEventListener(Bumped.class, (IWorldEventListener)this);
        }
    }

    private static class Entry<EVENT extends InfoMessage> {
        private EVENT event;
        private boolean queried;
        private double time;
        final /* synthetic */ Senses this$0;

        public Entry(EVENT event) {
            this.this$0 = var1_1;
            this.event = event;
            this.queried = false;
            this.time = var1_1.agentInfo.getTime();
        }
    }
}

