/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.logic;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReact;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReactOnce;
import cz.cuni.amis.pogamut.base.communication.worldview.react.ObjectEventReactOnce;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GamePaused;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameResumed;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.token.IToken;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004BotLogic<BOT extends UT2004Bot>
extends LogicModule<BOT> {
    private EventReact<GamePaused> pauseReaction;
    private EventReact<GameResumed> resumeReaction;
    private ObjectEventReactOnce<Self, ?> selfReaction;
    private ObjectEventReactOnce<GameInfo, ?> gameInfoReaction;
    private EventReact<EndMessage> endReaction;
    private BusAwareCountDownLatch latch;
    private Flag<Boolean> gameInfoCame = new Flag((Object)false);
    private Flag<Boolean> selfCame = new Flag((Object)false);
    private Flag<Boolean> endCame = new Flag((Object)false);

    @Inject
    public UT2004BotLogic(BOT agent, IAgentLogic logic) {
        this(agent, logic, null, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(((UT2004Bot)agent).getWorldView()));
    }

    public UT2004BotLogic(BOT agent, IAgentLogic logic, Logger log) {
        this(agent, logic, log, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(((UT2004Bot)agent).getWorldView()));
    }

    public UT2004BotLogic(BOT agent, IAgentLogic logic, Logger log, ComponentDependencies dependencies) {
        super(agent, logic, log, dependencies);
        this.pauseReaction = new EventReact<GamePaused>(GamePaused.class, ((UT2004Bot)agent).getWorldView()){

            protected void react(GamePaused event) {
                UT2004BotLogic.this.controller.manualPause("Game paused.");
            }
        };
        this.resumeReaction = new EventReact<GameResumed>(GameResumed.class, ((UT2004Bot)agent).getWorldView()){

            protected void react(GameResumed event) {
                UT2004BotLogic.this.controller.manualResume("Game resumed.");
            }
        };
        this.gameInfoReaction = new ObjectEventReactOnce<GameInfo, IWorldObjectEvent<GameInfo>>(GameInfo.class, ((UT2004Bot)agent).getWorldView()){

            protected void react(IWorldObjectEvent<GameInfo> event) {
                if (((GameInfo)event.getObject()).isBotsPaused() || ((GameInfo)event.getObject()).isGamePaused()) {
                    UT2004BotLogic.this.controller.manualPause("Bot launched into paused game.");
                }
                UT2004BotLogic.this.gameInfoCame.setFlag((Object)true);
            }
        };
        this.selfReaction = new ObjectEventReactOnce<Self, IWorldObjectEvent<Self>>(Self.class, ((UT2004Bot)agent).getWorldView()){

            protected void react(IWorldObjectEvent<Self> event) {
                UT2004BotLogic.this.selfCame.setFlag((Object)true);
            }
        };
        this.endReaction = new EventReactOnce<EndMessage>(EndMessage.class, ((UT2004Bot)agent).getWorldView()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void react(EndMessage event) {
                Flag flag = UT2004BotLogic.this.endCame;
                synchronized (flag) {
                    UT2004BotLogic.this.endCame.setFlag((Object)true);
                    UT2004BotLogic.this.latch.countDown();
                }
            }
        };
        this.cleanUp();
    }

    protected void logicLatch(String threadName) {
        boolean came;
        super.logicLatch(threadName);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(threadName + ": Waiting for the first End message.");
        }
        if (!this.latch.await(120L, TimeUnit.SECONDS)) {
            throw new ComponentCantStartException("End message was not received in 120secs.", (IComponent)this);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(threadName + ": First END message received, starting logic cycles.");
        }
        if (!(came = ((Boolean)this.selfCame.waitFor(60000L, (Object[])new Boolean[]{true})).booleanValue())) {
            throw new ComponentCantStartException(threadName + ": SELF message DID NOT COME in 60secs! Even though End message has been received.", (IComponent)this);
        }
        if (!((Boolean)this.gameInfoCame.getFlag()).booleanValue() && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(threadName + ": GAMEINFO message DID NOT COME! Even though End message has been received. Was it disabled in GameBot2004.ini? Or is it a bug... ?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(boolean startPaused) throws AgentException {
        super.start(startPaused);
        Flag<Boolean> flag = this.endCame;
        synchronized (flag) {
            this.latch = new BusAwareCountDownLatch(1, ((UT2004Bot)this.agent).getEventBus(), new IToken[]{((UT2004Bot)this.agent).getWorldView().getComponentId()});
            if (((Boolean)this.endCame.getFlag()).booleanValue()) {
                this.latch.countDown();
            }
        }
    }

    protected void cleanUp() throws AgentException {
        super.cleanUp();
        this.gameInfoCame.setFlag((Object)false);
        this.selfCame.setFlag((Object)false);
        this.gameInfoReaction.enable();
        this.selfReaction.enable();
        this.endReaction.enable();
        this.endCame.setFlag((Object)false);
    }
}

