package cz.cuni.amis.pogamut.ut2004.agent.navigation.astar;

import java.util.Collection;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.utils.astar.AStarGoal;

public abstract class UT2004AStarGoal implements AStarGoal<NavPoint> {

	protected Collection<NavPoint> closeList;
	
	protected Collection<NavPoint> openList;
	
	@Override
	public void setCloseList(Collection<NavPoint> closeList) {
		this.closeList = closeList;
	}

	@Override
	public void setOpenList(Collection<NavPoint> openList) {
		this.openList = openList;
	}

	public Collection<NavPoint> getCloseList() {
		return closeList;
	}

	public Collection<NavPoint> getOpenList() {
		return openList;
	}

	/**
	 * Method defining extra-edge cost, see {@link AStarGoal#getExtraCost(Object, Object)}. You probably won't need to use that, thus
	 * it is not abstract.
	 * <p><p>
	 * Returns: always 0
	 */
	@Override
	public int getExtraCost(NavPoint nodeFrom, NavPoint nodeTo) {
		return 0;
	}

	/**
	 * Method defining which nodes are allowed to be explored and which are forbidden, see {@link AStarGoal#isNodeOpened(Object)}. You probably
	 * won't need to use that, thus it is not abstract.
	 * <p><p>
	 * Returns: always 0
	 */
	@Override
	public boolean isNodeOpened(NavPoint node) {
		return true;
	}

	/**
	 * Method defining "heuristic" for A*, see {@link AStarGoal#getEstimatedDistanceToGoal(Object)}. You will usually want to return
	 * Euclidian distance between 'node' and your goal using {@link NavPoint#getLocation()} and {@link Location#getDistance(Location)}.
	 * See also {@link UT2004AStarGoalNavPoint}. 
	 * 
	 * @param node
	 */
	@Override
	public abstract int getEstimatedDistanceToGoal(NavPoint node);
	
	/**
	 * This tests whether 'actualNode' matches your desired 'goalNode'. You will usually use "==" to do that as every NavPoint
	 * is "sort-of" singleton for single agent (note that every agent has different one, so you might want to equals their ids via  {@link NavPoint#getId()}).
	 * 
	 * @param actualNode
	 */
	@Override
	public abstract boolean isGoalReached(NavPoint actualNode);
	
}
