/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot;

import cz.cuni.amis.pogamut.ut2004.bot.UT2004BotTestController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.server.exception.UCCStartException;
import cz.cuni.amis.pogamut.ut2004.test.UT2004Test;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.utils.StopWatch;
import java.util.concurrent.TimeUnit;

public abstract class UT2004BotTest
extends UT2004Test {
    @Override
    public void startUCC(UCCWrapper.UCCWrapperConf uccConf) throws UCCStartException {
        uccConf.setMapName(this.getMapName());
        uccConf.setGameType(this.getGameType());
        super.startUCC(uccConf);
    }

    protected String getGameType() {
        return "BotDeathMatch";
    }

    protected String getMapName() {
        return "DM-Flux2";
    }

    protected void startTest(Class<? extends UT2004BotTestController> controllerClass) {
        this.startTest(controllerClass, 1.0);
    }

    protected void startTest(Class<? extends UT2004BotTestController> controllerClass, double latchWaitMinutes) {
        this.startTest(controllerClass, latchWaitMinutes, null);
    }

    protected void startTest(Class<? extends UT2004BotTestController> controllerClass, double latchWaitMinutes, int agentsCount) {
        UT2004BotParameters[] params = new UT2004BotParameters[agentsCount];
        for (int i = 0; i < agentsCount; ++i) {
            params[i] = new UT2004BotParameters();
        }
        this.startTest(controllerClass, latchWaitMinutes, params);
    }

    protected void startTest(Class<? extends UT2004BotTestController> controllerClass, double latchWaitMinutes, UT2004BotParameters ... params) {
        int numParams = params == null || params.length == 0 ? 0 : params.length;
        int numBots = numParams == 0 ? 1 : numParams;
        UT2004Bot[] bots = params == null || params.length == 0 ? new UT2004Bot[]{this.startUTBot(controllerClass)} : this.startAllUTBots(controllerClass, params).toArray(new UT2004Bot[0]);
        long timeoutInMillis = (long)(latchWaitMinutes * 60.0 * 1000.0);
        StopWatch watches = new StopWatch();
        for (int i = 0; i < numBots; ++i) {
            UT2004BotTestController controller = (UT2004BotTestController)bots[i].getController();
            try {
                controller.getTestLatch().await((long)((double)timeoutInMillis - watches.check()), TimeUnit.MILLISECONDS);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                for (int j = i; j < numBots; ++j) {
                    bots[j].kill();
                }
                Throwable throwable = controller.getLogicModule().getLogicException();
                throw new RuntimeException("Test failed, bot did not finished.", throwable);
            }
            if ((double)timeoutInMillis - watches.check() < 0.0) {
                controller.timeout();
            }
            bots[i].kill();
            if (controller.isFailure()) {
                for (int j = i + 1; j < numBots; ++j) {
                    bots[j].kill();
                }
                if (controller.getMessage() != null) {
                    System.out.println("[ERROR] " + controller.getMessage());
                }
                String exceptionMessage = "Test has failed!";
                if (controller.getMessage() == null) {
                    exceptionMessage = exceptionMessage + " " + controller.getMessage();
                }
                throw new RuntimeException(exceptionMessage, controller.getCause());
            }
            if (controller.getMessage() == null) continue;
            System.out.println("[OK] " + controller.getMessage());
        }
        System.out.println("---/// TEST OK ///---");
    }
}

