/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.IGhostAgent;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.PrecomputedPathFuture;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.KefikRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.LoqueNavigator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.future.FutureStatus;
import cz.cuni.amis.utils.future.FutureWithListeners;
import cz.cuni.amis.utils.future.IFutureListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class UT2004Navigation {
    private UT2004PathExecutor<ILocated> pathExecutor;
    private FloydWarshallMap fwMap;
    private ILocated lastLocationTarget;
    private ILocated currentLocationTarget = null;
    private IPathFuture currentFuturePath;
    private UT2004Bot bot;
    private static final int NEW_PATH_DISTANCE_THRESHOLD = 20;
    private static final int ARRIVED_AT_LOCATION_XY_THRESHOLD = 50;
    private static final int ARRIVED_AT_LOCATION_Z_THRESHOLD = 100;
    private boolean bUsingUserPath = false;
    FlagListener<IPathExecutorState> myUT2004PathExecutorStateListener = new FlagListener<IPathExecutorState>(){

        public void flagChanged(IPathExecutorState changedValue) {
            switch (changedValue.getState()) {
                case PATH_COMPUTATION_FAILED: 
                case TARGET_REACHED: {
                    break;
                }
            }
        }
    };
    IFutureListener<List<ILocated>> myIPathFutureListener = new IFutureListener<List<ILocated>>(){

        public void futureEvent(FutureWithListeners<List<ILocated>> source, FutureStatus oldStatus, FutureStatus newStatus) {
            if (newStatus == FutureStatus.FUTURE_IS_READY) {
                if (!((List)source.get()).isEmpty()) {
                    ILocated lastPathElement = (ILocated)((List)source.get()).get(((List)source.get()).size() - 1);
                    if (lastPathElement.getLocation().getDistance(UT2004Navigation.this.currentLocationTarget.getLocation()) > 20.0) {
                        UT2004Navigation.this.currentFuturePath.get().add(UT2004Navigation.this.currentLocationTarget);
                        UT2004Navigation.this.pathExecutor.followPath(UT2004Navigation.this.currentFuturePath);
                    }
                } else {
                    UT2004Navigation.this.currentFuturePath.get().add(UT2004Navigation.this.currentLocationTarget);
                    UT2004Navigation.this.pathExecutor.followPath(UT2004Navigation.this.currentFuturePath);
                }
            }
        }
    };

    private void processIPathFuture(IPathFuture futurePath) {
        List pathList = futurePath.get();
        if (pathList == null) {
            return;
        }
        if (!pathList.isEmpty()) {
            ILocated lastPathElement = (ILocated)pathList.get(pathList.size() - 1);
            if (lastPathElement.getLocation().getDistance(this.currentLocationTarget.getLocation()) > 20.0) {
                this.currentFuturePath.get().add(this.currentLocationTarget);
            }
        } else {
            this.currentFuturePath.get().add(this.currentLocationTarget);
        }
    }

    public boolean isNavigating() {
        return this.pathExecutor.isExecuting();
    }

    public void navigate(ILocated location) {
        this.lastLocationTarget = this.currentLocationTarget;
        this.currentLocationTarget = location;
        if (this.currentLocationTarget == null) {
            if (this.pathExecutor.isExecuting()) {
                this.pathExecutor.stop();
            }
            this.bUsingUserPath = false;
            this.currentFuturePath = null;
            return;
        }
        if (!this.pathExecutor.isExecuting()) {
            this.currentFuturePath = this.fwMap.computePath(this.getNearestNavPoint((ILocated)this.bot.getLocation()), this.getNearestNavPoint(this.currentLocationTarget));
            this.bUsingUserPath = false;
            if (this.currentFuturePath.isDone()) {
                this.processIPathFuture(this.currentFuturePath);
            } else {
                this.currentFuturePath.addFutureListener(this.myIPathFutureListener);
            }
            this.pathExecutor.followPath(this.currentFuturePath);
        } else if (this.bUsingUserPath || this.lastLocationTarget != this.currentLocationTarget && this.lastLocationTarget.getLocation().getDistance(this.currentLocationTarget.getLocation()) > 20.0) {
            this.currentFuturePath = this.fwMap.computePath(this.getNearestNavPoint((ILocated)this.bot.getLocation()), this.getNearestNavPoint(this.currentLocationTarget));
            this.bUsingUserPath = false;
            if (this.currentFuturePath.isDone()) {
                this.processIPathFuture(this.currentFuturePath);
            } else {
                this.currentFuturePath.addFutureListener(this.myIPathFutureListener);
            }
            this.pathExecutor.followPath(this.currentFuturePath);
        } else {
            List pathExecutorPath = this.pathExecutor.getPath();
            if (!pathExecutorPath.isEmpty()) {
                ILocated lastPathExecutorPathElement = (ILocated)pathExecutorPath.get(pathExecutorPath.size() - 1);
                if (!this.currentFuturePath.get().isEmpty()) {
                    ILocated lastCurrentPathElement = (ILocated)this.currentFuturePath.get().get(this.currentFuturePath.get().size() - 1);
                    if (lastPathExecutorPathElement.getLocation().getDistance(lastCurrentPathElement.getLocation()) > 20.0) {
                        this.currentFuturePath = this.fwMap.computePath(this.getNearestNavPoint((ILocated)this.bot.getLocation()), this.getNearestNavPoint(this.currentLocationTarget));
                        this.bUsingUserPath = false;
                        if (this.currentFuturePath.isDone()) {
                            this.processIPathFuture(this.currentFuturePath);
                        } else {
                            this.currentFuturePath.addFutureListener(this.myIPathFutureListener);
                        }
                        this.pathExecutor.followPath(this.currentFuturePath);
                    }
                }
            }
        }
    }

    public void navigate(List<ILocated> path) {
        if (path == null || path.isEmpty()) {
            if (this.pathExecutor.isExecuting()) {
                this.pathExecutor.stop();
            }
            this.currentLocationTarget = null;
            this.currentFuturePath = null;
            this.bUsingUserPath = false;
            return;
        }
        if (!this.pathExecutor.isExecuting()) {
            this.currentFuturePath = new PrecomputedPathFuture((Object)path.get(0), (Object)path.get(path.size() - 1), path);
            this.bUsingUserPath = true;
            this.pathExecutor.followPath(this.currentFuturePath);
        } else if (this.currentFuturePath == null) {
            this.bot.getLog().warning("In:UT2004Navigation:navigate(List<ILocated> path): weird state - pathExecutor running and currentFuturePath is null");
            this.currentFuturePath = new PrecomputedPathFuture((Object)path.get(0), (Object)path.get(path.size() - 1), path);
            this.bUsingUserPath = true;
            this.pathExecutor.followPath(this.currentFuturePath);
        } else {
            List oldPath = this.currentFuturePath.get();
            if (!this.bUsingUserPath || oldPath == null || oldPath.isEmpty() || oldPath.size() != path.size()) {
                System.out.println("In:UT2004Navigation:navigate(List<ILocated> path):BEEN5");
                this.currentFuturePath = new PrecomputedPathFuture((Object)path.get(0), (Object)path.get(path.size() - 1), path);
                this.bUsingUserPath = true;
                this.pathExecutor.followPath(this.currentFuturePath);
            } else if (oldPath != path) {
                int i = 0;
                for (ILocated iLoc : path) {
                    if (oldPath.get(i) == null || ((ILocated)oldPath.get(i)).getLocation().getDistance(iLoc.getLocation()) > 20.0) {
                        this.currentFuturePath = new PrecomputedPathFuture((Object)path.get(0), (Object)path.get(path.size() - 1), path);
                        this.bUsingUserPath = true;
                        this.pathExecutor.followPath(this.currentFuturePath);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public List<ILocated> getCurrentPathCopy() {
        ArrayList<ILocated> result = new ArrayList<ILocated>();
        if (this.currentFuturePath != null) {
            result.addAll(this.currentFuturePath.get());
        }
        return result;
    }

    public List<ILocated> getCurrentPathDirect() {
        if (this.currentFuturePath != null) {
            return this.currentFuturePath.get();
        }
        return null;
    }

    private NavPoint getNearestNavPoint(ILocated location) {
        NavPoint result = null;
        for (NavPoint nav : this.bot.getWorldView().getAll(NavPoint.class).values()) {
            if (result != null && !(location.getLocation().getDistance(result.getLocation()) > location.getLocation().getDistance(nav.getLocation()))) continue;
            result = nav;
        }
        return result;
    }

    public void addStrongNavigationListener(FlagListener<IPathExecutorState> listener) {
        this.pathExecutor.getState().addStrongListener(listener);
    }

    public void removeStrongNavigationListener(FlagListener<IPathExecutorState> listener) {
        this.pathExecutor.getState().removeListener(listener);
    }

    public void setFocus(ILocated located) {
        this.pathExecutor.setFocus(located);
    }

    public void stopNavigation() {
        this.pathExecutor.stop();
        this.currentLocationTarget = null;
        this.lastLocationTarget = null;
        this.currentFuturePath = null;
        this.bUsingUserPath = false;
    }

    public void addStuckDetector(IStuckDetector stuckDetector) {
        this.pathExecutor.addStuckDetector(stuckDetector);
    }

    public void removeStuckDetector(IStuckDetector stuckDetector) {
        this.pathExecutor.removeStuckDetector(stuckDetector);
    }

    public List<IStuckDetector> getStuckDetectors() {
        return this.pathExecutor.getStuckDetectors();
    }

    public UT2004Navigation(UT2004Bot bot, UT2004PathExecutor ut2004PathExecutor, FloydWarshallMap fwMap) {
        this.bot = bot;
        this.pathExecutor = ut2004PathExecutor;
        this.fwMap = fwMap;
        ut2004PathExecutor.getState().addListener(this.myUT2004PathExecutorStateListener);
    }

    public UT2004Navigation(UT2004Bot bot, FloydWarshallMap fwMap) {
        this.bot = bot;
        this.fwMap = fwMap;
        KefikRunner kRunner = new KefikRunner(bot, new AgentInfo(bot), new AdvancedLocomotion(bot, (Logger)bot.getLog()), (Logger)bot.getLog());
        LoqueNavigator lNav = new LoqueNavigator(bot, kRunner, (Logger)bot.getLog());
        this.pathExecutor = new UT2004PathExecutor(bot, lNav);
        this.pathExecutor.addStuckDetector(new UT2004TimeStuckDetector(bot));
        this.pathExecutor.addStuckDetector(new UT2004PositionStuckDetector(bot));
        this.pathExecutor.getState().addListener(this.myUT2004PathExecutorStateListener);
    }

    public UT2004Navigation(UT2004Bot bot) {
        this.bot = bot;
        this.fwMap = new FloydWarshallMap((IGhostAgent)bot);
        KefikRunner kRunner = new KefikRunner(bot, new AgentInfo(bot), new AdvancedLocomotion(bot, (Logger)bot.getLog()), (Logger)bot.getLog());
        LoqueNavigator lNav = new LoqueNavigator(bot, kRunner, (Logger)bot.getLog());
        this.pathExecutor = new UT2004PathExecutor(bot, lNav);
        this.pathExecutor.addStuckDetector(new UT2004TimeStuckDetector(bot));
        this.pathExecutor.addStuckDetector(new UT2004PositionStuckDetector(bot));
        this.pathExecutor.getState().addListener(this.myUT2004PathExecutorStateListener);
    }

    public UT2004Navigation(UT2004Bot bot, AgentInfo info, AdvancedLocomotion locomotion) {
        this.bot = bot;
        this.fwMap = new FloydWarshallMap((IGhostAgent)bot);
        KefikRunner kRunner = new KefikRunner(bot, info, locomotion, (Logger)bot.getLog());
        LoqueNavigator lNav = new LoqueNavigator(bot, kRunner, (Logger)bot.getLog());
        this.pathExecutor = new UT2004PathExecutor(bot, lNav);
        this.pathExecutor.addStuckDetector(new UT2004TimeStuckDetector(bot));
        this.pathExecutor.addStuckDetector(new UT2004PositionStuckDetector(bot));
        this.pathExecutor.getState().addListener(this.myUT2004PathExecutorStateListener);
    }
}

