/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.ListenerLevel;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.WorldViewTestContext;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.AbstractObjectEventWrapper;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.EventWrapper;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.EventWrapperWithCallCount;
import java.util.logging.Level;
import org.junit.Assert;

@XStreamAlias(value="ObjectInstanceEventWrapper")
public class ObjectInstanceEventWrapper<OBJECT extends IWorldObject>
extends AbstractObjectEventWrapper<OBJECT> {
    @XStreamAlias(value="Id")
    private final UnrealId id;
    @XStreamOmitField
    private ObjectInstanceListenerWrapper<IWorldObjectEvent<OBJECT>> listenerWrapper;

    public ObjectInstanceEventWrapper(WorldViewTestContext ctx, IWorldObjectEvent<OBJECT> expectedEvent, UnrealId id, ListenerLevel level) {
        super(ctx, (IWorldEvent)expectedEvent, level);
        Assert.assertTrue((String)"Use ObjectClassEventWrapper, if you wish to register a class B or C listener.", (level == ListenerLevel.D || level == ListenerLevel.E ? 1 : 0) != 0);
        this.id = id;
    }

    @Override
    protected void setListenerWrapper() {
        this.listenerWrapper = new ObjectInstanceListenerWrapper();
    }

    @Override
    public void registerToWorldView(IWorldView worldView) {
        if (!worldView.isListening((WorldObjectId)this.id, this.listenerWrapper) && !worldView.isListening((WorldObjectId)this.id, this.getExpectedEvent().getClass(), this.listenerWrapper)) {
            if (this.ctx.getLog().isLoggable(Level.INFO)) {
                this.ctx.getLog().info("Registering listener of: " + this.getExpectedEventString());
            }
            switch (this.getListenerLevel()) {
                case D: {
                    worldView.addObjectListener((WorldObjectId)this.id, this.listenerWrapper);
                    break;
                }
                case E: {
                    worldView.addObjectListener((WorldObjectId)this.id, this.getExpectedEvent().getClass(), this.listenerWrapper);
                }
            }
        }
    }

    public UnrealId getId() {
        return this.id;
    }

    protected class ObjectInstanceListenerWrapper<EVENT extends IWorldObjectEvent<OBJECT>>
    implements IWorldObjectEventListener<OBJECT, EVENT> {
        protected ObjectInstanceListenerWrapper() {
        }

        public void notify(EVENT event) {
            EventWrapperWithCallCount mock_wrapper_with_counts = ObjectInstanceEventWrapper.this.ctx.getCurrentMockWrapper();
            if (ObjectInstanceEventWrapper.this.ctx.getLog().isLoggable(Level.INFO)) {
                ObjectInstanceEventWrapper.this.ctx.getLog().info("ObjectInstanceListenerNotify: " + event.toString() + " call#: " + (mock_wrapper_with_counts.getCalled() + 1));
            }
            Assert.assertTrue((String)("Invalid UnrealId reported with event: " + event.toString() + "\n" + ObjectInstanceEventWrapper.this.id.getStringId() + " was expected."), (boolean)event.getId().getStringId().equals(ObjectInstanceEventWrapper.this.id.getStringId()));
            EventWrapper test = mock_wrapper_with_counts.getEventWrapper();
            Assert.assertTrue((String)("Unexpected event has been raised (possibly out of order).\n" + event.toString() + "\nExpected for this listener: " + ObjectInstanceEventWrapper.this.getExpectedEventString() + "\nExpected for strict execution: " + mock_wrapper_with_counts.getEventWrapper().getExpectedEventString()), (!ObjectInstanceEventWrapper.this.ctx.isStrictExecution() || test.getExpectedEvent().equals(ObjectInstanceEventWrapper.this.getExpectedEvent()) && event.getClass() == test.getExpectedEvent().getClass() && mock_wrapper_with_counts.getEventWrapper() instanceof ObjectInstanceEventWrapper && event.getId().equals((Object)((ObjectInstanceEventWrapper)mock_wrapper_with_counts.getEventWrapper()).getId()) && ObjectInstanceEventWrapper.this.id.equals((Object)((ObjectInstanceEventWrapper)mock_wrapper_with_counts.getEventWrapper()).getId()) ? 1 : 0) != 0);
            ObjectInstanceEventWrapper.this.notify((IWorldEvent)event);
        }
    }
}

