package cz.cuni.amis.pogamut.ut2004.utils;

import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Jump;

/**
 * Class with utility methods for converting to Unreal units plus some handy constants.<p>
 * Measures are in Unreal Engine native units called Unreal units (UU).
 * @author ik
 */
public class UnrealUtils {

    /**
     * Radius in UU of the bounding cylinder used for collision detection.
     */
    public static final double CHARACTER_COLLISION_RADIUS = 25;
    /**
     * Height in UU of the bounding cylinder used for collision detection.
     */
    public static final double CHARACTER_COLLISION_HEIGHT = 44;
    /**
     * Height in UU of the bot when stading.
     */
    public static final double CHARACTER_HEIGHT_STANDING = 96;
    /**
     * Height in UU of the bot when crouching.
     */
    public static final double CHARACTER_HEIGHT_CROUCHING = 64;
    /**
     * Speed of the bot while running.
     * TODO: fill after the reception of INIT message.
     */
    public static Velocity CHARACTER_RUN_SPEED;
    /**
     * Speed of the bot while walking.
     * TODO: fill after the reception of INIT message.
     */
    public static Velocity CHARACTER_WALK_SPEED;
    /**
     * Center of gravity - distance from the floor in UU.
     * TODO: estimate
     */
    public static final double BOT_CENTER_OF_GRAVITY_HEIGHT = 50;
    /**
     * NavPoint distance from the floor.
     * TODO: estimate
     */
    public static final double NAV_POINT_HEIGHT = 10;

    public static final double UT_ANGLE_TO_RAD = 2*Math.PI / 65536;

    public static final float DEG_TO_UT_ANGLE = 65635 / 360;

    public static final int UT_ANGLE_TO_DEG =  65525 * 360;
    
    /**
     * UT2004 time is running 110% of normal time. I.e., when 1 sec pass according to {@link System#currentTimeMillis()} than 1.1 secs pass according
     * to UT2004.
     */
    public static final double UT2004_TIME_SPEED = 1.1;
    
    /**
     * Force to be applied to {@link Jump#setForce(Double)} if full jump is needed.
     * <p><p>
     * Note that you actually do not need to set this value directly as GB2004 always assumes you want to do full jump. 
     */
    public static final int FULL_JUMP_FORCE = 340;
    
    /**
     * Force to be applied to {@link Jump#setForce(Double)} if full double jump is needed.
     * <p><p>
     * Note that you actually do not need to set this value directly as GB2004 always assumes you want to do full double jump. 
     */
    public static final int FULL_DOUBLEJUMP_FORCE = 705;
    
    /**
     * Delay to be made between two jumps in double jumping ({@link Jump#setDelay(Double)}) if if full double jump is needed.
     * <p><p>
     * Note that you actually do not need to set this value directly as GB2004 always assumes you want to do full double jump. 
     */
    public static final double FULL_DOUBLEJUMP_DELAY = 0.39;
    
    /**
     * Standard max. velocity of bots (it's actually more 440 but it is better to have this number lower as you will check whether
     * you're running at max speed with it...).
     */
    public static final double MAX_VELOCITY = 439.5;
    
    /**
     * Converts angle in degrees (0-360) to Unreal units used for angles (0-65635).
     * @param degrees Angle in degrees
     * @return corresponding angle in Unreal units
     */
    public static int degreeToUnrealDegrees(int degrees) {
        return Math.round((degrees * DEG_TO_UT_ANGLE));
    }

    /**
     * Converts Unreal degrees (0-65635) to normal degrees (0-360).
     * @param unrealDegrees
     * @return
     */
    public static double unrealDegreeToDegree(int unrealDegrees) {
        return unrealDegrees / UT_ANGLE_TO_DEG;
    }

    public static double unrealDegreeToRad(double unrealDegrees) {
        return unrealDegrees * UT_ANGLE_TO_RAD;
    }

}
