package cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.converter;


import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.ListenerLevel;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.WorldViewTestContext;

public abstract class ObjectEventWrapperConverter extends EventWrapperConverter {

	public ObjectEventWrapperConverter(WorldViewTestContext ctx) {
		super(ctx);		
	}
			
	@Override
	public Object unmarshal(HierarchicalStreamReader reader,
			UnmarshallingContext context) {
		
		DeserializedWrapperData data = new DeserializedWrapperData();
		
		data.level =
			ListenerLevel.valueOf(reader.getAttribute("level"));
			
		if (reader.hasMoreChildren()) {			
			reader.moveDown();
						
			if ((reader.getNodeName().equals("ExpectedEvent")) &&
					(!reader.getValue().isEmpty() || reader.getAttribute("reference") != null)) {
				data.expectedEvent =
						(IWorldEvent) context.convertAnother(this, context.getRequiredType());
			}
			reader.moveUp();
		}
	
		return data;		
	}

}
