package cz.cuni.amis.pogamut.ut2004.communication.translator.testplan;

import java.util.LinkedList;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;

public class ListsWrapperForConversionConverter implements Converter {

	@Override
	public void marshal(Object value, HierarchicalStreamWriter writer,
			MarshallingContext context) {

		ListsWrapperForConversion wrapper = (ListsWrapperForConversion) value;

		writer.startNode("InputEvents");
		context.convertAnother(wrapper.messages);
		writer.endNode();

		writer.startNode("ExpectedEvents");
		context.convertAnother(wrapper.defaultOutput);
		writer.endNode();

	}

	@SuppressWarnings("unchecked")
	@Override
	public Object unmarshal(HierarchicalStreamReader reader,
			UnmarshallingContext context) {

		reader.moveDown();
		LinkedList<InfoMessage> messages =
			(LinkedList<InfoMessage>) context.convertAnother(this, LinkedList.class);		
		reader.moveUp();

		reader.moveDown();
		LinkedList<IWorldChangeEvent> defaultOutput	=
			(LinkedList<IWorldChangeEvent>) context.convertAnother(this, LinkedList.class);	
		reader.moveUp();

		return new ListsWrapperForConversion(messages, defaultOutput);
	}

	@SuppressWarnings("unchecked")
	@Override
	public boolean canConvert(Class clazz) {
		return clazz == ListsWrapperForConversion.class;
	}
}
