/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.analyzer;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.analyzer.IUT2004AnalyzerObserver;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004AnalyzerObserverParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ConfigurationObserver;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.InitializeObserver;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameRestarted;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.observer.impl.UT2004Observer;
import cz.cuni.amis.utils.exception.PogamutException;
import java.io.File;

public class UT2004AnalyzerObserver
extends UT2004Observer
implements IUT2004AnalyzerObserver {
    private UnrealId observedBotId;
    private IWorldEventListener<GameRestarted> gameRestartedListener = new IWorldEventListener<GameRestarted>(){

        public void notify(GameRestarted event) {
            if (event.isStarted()) {
                UT2004AnalyzerObserver.this.gameRestartStarted();
            } else if (event.isFinished()) {
                UT2004AnalyzerObserver.this.gameRestartEnd();
            } else {
                throw new PogamutException("GameRestarted has started==false && finished==false as well, invalid!", (Object)this);
            }
        }
    };

    @Inject
    public UT2004AnalyzerObserver(UT2004AnalyzerObserverParameters params, IComponentBus bus, IAgentLogger agentLogger, UT2004WorldView worldView, IAct act) {
        super(params, bus, agentLogger, worldView, act);
        this.observedBotId = UnrealId.get((String)params.getObservedAgentId());
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(GameRestarted.class, this.gameRestartedListener);
    }

    @Override
    public UT2004AnalyzerObserverParameters getParams() {
        return (UT2004AnalyzerObserverParameters)super.getParams();
    }

    @Override
    public UnrealId getObservedBotId() {
        return this.observedBotId;
    }

    public String getOutputFilePath() {
        String path = this.getParams().getOutputPath();
        if (path == null) {
            path = ".";
        }
        path = String.valueOf(path) + File.separator;
        if (this.getParams().getFileName() != null) {
            path = String.valueOf(path) + this.getParams().getFileName();
        } else {
            path = String.valueOf(path) + this.getObservedBotId().toString();
            path = String.valueOf(path) + ".csv";
        }
        return path;
    }

    protected void gameRestartStarted() {
    }

    protected void gameRestartEnd() {
    }

    @Override
    protected void startAgent() {
        super.startAgent();
        this.getAct().act((CommandMessage)new InitializeObserver().setId(this.getParams().getObservedAgentId()));
        this.configureObserver();
    }

    @Override
    protected void startPausedAgent() {
        super.startPausedAgent();
        this.getAct().act((CommandMessage)new InitializeObserver().setId(this.getParams().getObservedAgentId()));
        this.configureObserver();
    }

    protected void configureObserver() {
        this.getAct().act((CommandMessage)new ConfigurationObserver().setUpdate(0.2).setAll(true).setSelf(true).setAsync(true).setGame(false).setSee(false).setSpecial(false));
    }
}

