package cz.cuni.amis.pogamut.usar2004.communication.translator;

import java.util.logging.Logger;

import com.google.inject.Inject;

import cz.cuni.amis.fsm.FSM;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldMessageTranslator;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.exception.TranslatorException;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.usar2004.communication.translator.state.DefaultState;


/**
 * BotFSM is wrapper for the FSM instance that uses states from cz.cuni.amis.pogamut.ut2004.communication.translator.bot package.
 *
 * @author Jimmy
 */
public class USARBotFSM implements IWorldMessageTranslator {

	private IWorldEventQueue eventQueue = new IWorldEventQueue.Queue();

	private USARTranslatorContext context = null;

	private FSM<InfoMessage, USARTranslatorContext> fsm = null;

	private Logger log;

	@Inject
	public USARBotFSM(IAgentLogger logger) {
		this.log = logger.getCategory(getClass().getSimpleName());
		context = new USARTranslatorContext(eventQueue, log);
                //TODO create protocol states
		fsm = new FSM<InfoMessage, USARTranslatorContext>(context, DefaultState.class, log);
	}

	@Override
	public IWorldChangeEvent[] processMessage(InfoMessage message) throws TranslatorException {
		fsm.push(context, message);
		return eventQueue.popEvents();
	}

	@Override
	public void reset() {
		context.reset();
		this.fsm.restart(context);
	}

    @Override
	public String toString() {
		return "USARBotFSM";
	}

}