package cz.cuni.amis.pogamut.usar2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;
import javax.vecmath.Point2d;

/**
 * Sensor message representative for Helper sensor.
 *
 * @author vejmanm
 */
public class SensorHelper extends SuperSensor
{
    public static final SensorType type = SensorType.HELPER_SENSOR;

    /**
     * Ctor. Sensor type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public SensorHelper()
    {
        super(type);
    }

    /**
     * AIBO - ERS robot uses tracking ball sensor, that recognises a soccer ball
     * from camera. Not in USARSim manual v3.1.3.
     *
     * @return Returns position on the camera of the soccer ball.
     */
    public Point2d getPos2D()
    {
        return lastMessage.getPos2D();
    }

    /**
     * AIBO - ERS robot uses tracking ball sensor, that recognises a soccer ball
     * from camera. Not in USARSim manual v3.1.3.
     *
     * @return Returns location of the soccer ball in the environment.
     */
    public Location getPos3D()
    {
        return lastMessage.getPos3D();
    }

    /**
     * AIBO - ERS robot uses tracking ball sensor, that recognises a soccer ball
     * from camera. Not in USARSim manual v3.1.3.
     *
     * @return Returns corona of the soccer ball.
     */
    public double getCorona()
    {
        return lastMessage.getCorona();
    }

    /**
     * AIBO - ERS robot uses tracking ball sensor, that recognises a soccer ball
     * from camera. Not in USARSim manual v3.1.3.
     *
     * @return Returns radius of the soccer ball.
     */
    public double getRadius()
    {
        return lastMessage.getRadius();
    }

    /**
     * AIBO - ERS robot uses tracking ball sensor, that recognises a soccer ball
     * from camera. Not in USARSim manual v3.1.3.
     *
     * @return Returns distance of the soccer ball from the robot.
     */
    public double getDistance()
    {
        return lastMessage.getDistance();
    }

    /**
     * AIBO - ERS robot uses tracking ball sensor, that recognises a soccer ball
     * from camera. Not in USARSim manual v3.1.3.
     *
     * @return Returns position on the camera of the soccer ball.
     */
    public boolean isVisible()
    {
        return lastMessage.isVisible();
    }
}
