package cz.cuni.amis.pogamut.usar2004.agent.module.response;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.ResponseType;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.ResponseMessage;

/**
 * Parent class for all possible response messages. It covers the basic and
 * common properties for all the response subjects.
 *
 * @author vejmanm
 */
public abstract class SuperResponse
{
    protected ResponseMessage lastMessage;
    protected ResponseType type;

    /**
     * Ctor.
     *
     * @param type Response type describes particular subject about which we
     * want to know about. It is used to distinguish incoming message from the
     * server.
     */
    public SuperResponse(ResponseType type)
    {
        this.type = type;
    }

    /**
     * Used to make sure the object is filled.
     *
     * @return Returns true if the object is filled with Resp. message.
     */
    public Boolean isReady()
    {
        return (lastMessage != null);
    }

    /**
     * Timestamp form the UT since server start in seconds.
     *
     * @return Returns seconds elapsed from the start of the server.
     */
    public double getTime()
    {
        return lastMessage.getTime();
    }

    /**
     * Type of the response will be one of the following: "ViewPorts”, “Camera”,
     * or some type of sensor or effecter.
     *
     * @return Returns Type of the response.
     */
    public String getType()
    {
        return lastMessage.getType();
    }

    /**
     * ResponseType is a descriptor used for creating particular instance and
     * for getting type information about particular response message.
     *
     * @return Returns ResponseType.
     */
    public ResponseType getResponseType()
    {
        return this.type;
    }

    /**
     * Method used for updating the message object that provides particular
     * properties for given type. Note that this object is created by yylex
     * parser and contains properties for all configuration subject types. But
     * only relevat to individual Response Subject are filled.
     *
     * @param message Response message from server.
     */
    public void updateMessage(ResponseMessage message)
    {
        this.lastMessage = message;
    }
}
