package cz.cuni.amis.pogamut.usar2004.agent.module.datatypes;

import cz.cuni.amis.pogamut.usar2004.agent.module.state.*;

/**
 * Descriptor of vehicle type. Every robot should by one of following types:
 * Ground, Nautic, Aerial or Legged Robot.
 *
 * @author vejmanm
 */
public enum VehicleType
{
    GROUND_VEHICLE(StateGround.class),
    LEGGED_ROBOT(StateLegged.class),
    NAUTIC_VEHICLE(StateNautic.class),
    AERIAL_VEHICLE(StateAerial.class),
    UNKNOWN(SuperState.class);
    private Class clazz;

    VehicleType(Class clazz)
    {
        this.clazz = clazz;
    }

    public Class getModuleClass()
    {
        return this.clazz;
    }

    /**
     * Used for creating instances of state message representatives.
     *
     * @param type String representation of vehicle type.
     * @return Returns corresponding enum element.
     */
    public static VehicleType getType(String type)
    {
        if(type.equalsIgnoreCase("GroundVehicle") || type.equalsIgnoreCase("Ground"))
        {
            return GROUND_VEHICLE;
        }
        if(type.equalsIgnoreCase("LeggedRobot") || type.equalsIgnoreCase("Legged"))
        {
            return LEGGED_ROBOT;
        }
        if(type.equalsIgnoreCase("NauticVehicle") || type.equalsIgnoreCase("Nautic"))
        {
            return NAUTIC_VEHICLE;
        }
        if(type.equalsIgnoreCase("AerialVehicle") || type.equalsIgnoreCase("Aerial"))
        {
            return AERIAL_VEHICLE;
        }
        return UNKNOWN;
    }
}
