package cz.cuni.amis.pogamut.usar2004.agent;

import java.util.logging.Level;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.NfoMessage;

@AgentScoped
public class USAR2004BotController<BOT extends USAR2004Bot> implements IUSAR2004BotController<BOT> {

    /**
     * Name of the log category of the user log.
     */
    public static final String USER_LOG_CATEGORY_ID = "User";
    /**
     * Instance of the bot we're controlling.
     */
    protected BOT bot;
    /**
     * User log - it's log-level is initially set to {@link Level#ALL}.
     * @deprecated use {@link UT2004BotController#log} instead
     */
    protected LogCategory user = null;
    /**
     * Alias for user's log.
     */
    protected LogCategory log = null;

    @Override
    public void initializeController(BOT bot) {
        this.bot = (BOT) bot;
        user = bot.getLogger().getCategory(USER_LOG_CATEGORY_ID);
        // sets the logger level, if we would let the logger level to be Level.All the bot would
        // be slowed significantly due to high number of messages
        bot.getLogger().setLevel(Level.WARNING);
        // set user-log to accept every message
        user.setLevel(Level.ALL);
        log = user;
    }

    @Override
    public void prepareBot(USAR2004Bot bot) {
    }

    @Override
    public void robotInitialized(NfoMessage nfoMessage) {
    }

    /**
    @Override
    public PasswordReply getPassword() {
    return new PasswordReply().setPassword("unspecified");
    }

    @Override
    public Initialize getInitializeCommand() {
    return new Initialize();
    }

    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
    }

    @Override
    public void botSpawned(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init, Self self) {
    }

    @Override
    public void finishControllerInitialization() {
    }

    @Override
    public void botKilled(BotKilled event) {
    }

    @Override
    public void botShutdown() {
    }**/
    public IVisionWorldView getWorldView() {
        return (IVisionWorldView) bot.getWorldView();
    }

    public IAct getAct() {
        return bot.getAct();
    }

    /**
     * Returns user logger. This call is equivalent to <code>bot.getLogger().getCategory(USER_LOG_ID)</code>.
     * @return
     */
    public LogCategory getLog() {
        return user;
    }
}
