package cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages;

import java.util.*;
import cz.cuni.amis.pogamut.base.communication.worldview.event.*;
import cz.cuni.amis.pogamut.base.communication.worldview.object.*;
import cz.cuni.amis.pogamut.base.communication.translator.event.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * Response message reports the message that user's been asking for. Please note
 * that the robot Response message parameters depend on the type of robot that
 * you are driving. For example, a robot of type “GroundVehicle” will not have
 * the same Response message as a robot of type “AerialVehicle.” * Corresponding
 * GameBots message is RES.
 *
 *
 *
 * A response message is delivered to describe the status of a command that has
 * been sent to USARSim. Response messages are used so that users can tell
 * whether or not particular commands were successfully executed. There are
 * three different response messages. The first response message is issued after
 * a SET {Type Viewports} command. The second response messaged is issued after
 * a SET {Type Camera} command. The third response message is a generic message
 * used for sensors and effecters. After a SET {Type Viewports} command, the
 * response message will be issued.
 *
 */
public class ResponseMessage extends GBEvent implements IWorldEvent, IWorldChangeEvent
{
    public ResponseMessage(double Time, String Type, String Config, String Status)
    {
        this.Type = Type;
        this.Time = Time;
        this.Config = Config;
        if(Status != null)
        {
            this.Statuses.add(Status);
        }
    }
    /**
     * Example how the message looks like - used during parser tests.
     */
    public static final String PROTOTYPE = "RES {Time 0} {Type text} {Config text}";
    /////// Properties BEGIN
    //After a SET {Type Viewports} command - Time, Type, Config, Status, Viewport1, Status, Viewport2, Status, Viewport3, Status, Viewport4, Status
    protected double Time = 0;

    /**
     * Timestamp form the UT since server start in seconds.
     *
     * @return Returns seconds elapsed from the start of the server.
     */
    public double getTime()
    {
        return Time;
    }
    protected String Type = null;

    /**
     * Type of the response will be one of the following: "ViewPorts”, “Camera”,
     * or some type of sensor or effecter.
     *
     * @return Returns Type of the response.
     */
    public String getType()
    {
        return Type;
    }
    // describes the current viewport configuration. This parameter will be either “SingleView” or “QuadView”
    protected String Config = null;

    /**
     * Describes the current viewport configuration. This parameter will be
     * either “SingleView” or “QuadView”
     *
     * @return Returns configuration of current viewport.
     */
    public String getConfig()
    {
        return Config;
    }
    //Note: First status is paird with config variable in this case, the others are linked with viewports!!
    protected List<String> Statuses = new ArrayList<String>();

    /**
     * Status of the viewport configuration after the SET command has been
     * issued. The status will be “OK” when the viewport configuration was
     * successfully changed. Otherwise, the status will be “Failed”.
     *
     * List of statuses is also used when setting cameras. Each value is then
     * the status for the camera’s field of view after the SET command has been
     * issued. The status will be “OK” when the camera’s field of view was
     * successfully changed. Otherwise, the status will be “Failed”.
     *
     * When responsing to SET command for sensor or effecter, single value
     * describing the status of the transaction will be present in the list.
     *
     * @return Returns List of status results.
     */
    public List<String> getStatuses()
    {
        return Statuses;
    }
    protected List<String> Viewports = new ArrayList<String>();

    /**
     * Each value is the name of the camera currently attached to viewportN,
     * where N is 1..4. If viewportN has been disabled, this parameter will be
     * “Disabled”. If viewportN has been attached to a non- existent camera,
     * this parameter will be “None”.
     *
     * @return Returns List of viewport values. Size of four.
     */
    public List<String> getViewports()
    {
        return Viewports;
    }
    //After a SET {Type Camera} command - Time, Type, Name, FOV, Status
    protected List<String> Names = new ArrayList<String>();

    /**
     * Name of the camera that will be described by the next two parameters: FOV
     * and Status.
     *
     * When responsing to SET command for sensor or effecter, single value will
     * be present in the list.
     *
     * @return Returns List of names of cameras.
     */
    public List<String> getNames()
    {
        return Names;
    }
    protected List<String> FOVs = new ArrayList<String>();

    /**
     * Each value is the current field of view of the camera being described, in
     * radians. The current field of view is the field of view after a SET {Type
     * Camera} has been issued.
     *
     * @return Returns List of fields of views of cameras.
     */
    public List<String> getFOVs()
    {
        return FOVs;
    }
    //The generic response message, issued for other sensors and effecters - Time, Type, Name, Status

    /**
     * Cloning constructor.
     */
    public ResponseMessage(ResponseMessage original)
    {
        this.Type = original.Type;
        this.Time = original.Time;
        this.Config = original.Config;
        this.FOVs.addAll(original.FOVs);
        this.Names.addAll(original.Names);
        this.Statuses.addAll(original.Statuses);
        this.Viewports.addAll(original.Viewports);
    }

    /**
     * Used by Yylex to create empty message then to fill it's protected fields
     * (Yylex is in the same package).
     */
    public ResponseMessage()
    {
    }
    /**
     * Here we save the original object for which this object is an update.
     */
    private IWorldObject orig = null;

    @Override
    public String toString()
    {
        StringBuilder buf = new StringBuilder();

        buf.append(super.toString() + " | "
                + "Type = "
                + String.valueOf(Type) + " | "
                + "Time = "
                + String.valueOf(Time) + " | "
                + "Config = "
                + String.valueOf(Config) + " | ");

        if(!Statuses.isEmpty())
        {
            for(String i : Statuses)
            {
                buf.append("Status = ").append(i).append(" ");
            }
            buf.append(" | ");
        }

        if(!Viewports.isEmpty())
        {
            for(int i = 0; i < Viewports.size(); i++)
            {
                buf.append("Viewport").append(i).append(" = ").append(Viewports.get(i)).append(" ");
            }
            buf.append(" | ");
        }

        if(!Names.isEmpty())
        {
            for(String i : Names)
            {
                buf.append("Names = ").append(i).append(" ");
            }
            buf.append(" | ");
        }

        if(!FOVs.isEmpty())
        {
            for(String i : FOVs)
            {
                buf.append("FOV = ").append(i).append(" ");
            }
            buf.append(" | ");
        }


        return buf.toString();


        /*
         * Statuses Viewports Names FOVs
         */

    }

    /**
     * Gets all properties and values to create a HTML formated string;
     *
     * @return Returns all properties in HTML format
     */
    public String toHtmlString()
    {
        StringBuilder buf = new StringBuilder();

        buf.append(super.toString()
                + "<b>Type</b> : "
                + String.valueOf(Type)
                + " <br/> "
                + "<b>Time</b> : "
                + String.valueOf(Time)
                + " <br/> "
                + "<b>Config</b> : "
                + String.valueOf(Config)
                + " <br/> ");

        if(!Statuses.isEmpty())
        {
            for(String i : Statuses)
            {
                buf.append("<b>Status</b> : ").append(i).append(" <br/> ");
            }
        }
        if(!Viewports.isEmpty())
        {
            for(int i = 0; i < Viewports.size(); i++)
            {
                buf.append("<b>Viewport").append(i).append("</b> : ").append(Viewports.get(i)).append(" <br/> ");
            }
        }
        if(!Names.isEmpty())
        {
            for(String i : Names)
            {
                buf.append("<b>Names</b> : ").append(i).append(" <br/> ");
            }
        }
        if(!FOVs.isEmpty())
        {
            for(String i : FOVs)
            {
                buf.append("<b>FOV</b> : ").append(i).append(" <br/> ");
            }
        }

        return buf.toString();
    }
}
