package cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands;

import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * This command is used to manage the viewpoint.
 *
 *
 *
 *
 * This command sets the viewpoint of the specified Unreal Client to a robot’s
 * camera. The unreal client is defined by ‘{Client ip}’ where ‘ip’ is the
 * client’s IP address. Please note USARSim doesn’t support the loopback ip
 * address. So don’t use “127.0.0.1” as the parameter. The robot is specified by
 * ‘{Robot string}’ where ‘string’ is the robot’s name. And the camera is
 * specified by ‘{Name string}’ where ‘string’ is the camera’s name. Once the
 * client’s viewpoint is set, we can NOT manually change it until we release the
 * viewpoint control. To release the control, we send another SET command
 * without ‘{robot name}’. For example, we can send “SET {Type Camera} {Client
 * 10.0.0.2}” to release the viewpoint control on client 10.0.0.2.
 *
 *
 * We can use this command at anytime and anyplace. This command can be sent
 * either from a robot’s controller or from other applications such as the
 * ImageServer.
 *
 * Corresponding GameBots command is SET.
 *
 */
public class SetViewpoint extends CommandMessage
{
    //constructor for the joints
    public SetViewpoint(String Robot, String Name, String Client)
    {
        this.Robot = Robot;
        this.Name = Name;
        this.Client = Client;
    }

    /**
     * <p></p>WARNING: this is empty-command constructor, you have to use
     * Setters to fill it up!
     */
    public SetViewpoint()
    {
    }
    /////// Properties BEGIN
    protected String Type = "Camera";

    public String getType()
    {
        return Type;
    }
    //Cameras name
    protected String Name = null;

    public String getName()
    {
        return Name;
    }

    public SetViewpoint SetViewpointName(String Name)
    {
        this.Name = Name;
        return this;
    }
    //Robots name
    protected String Robot = null;

    public String getRobot()
    {
        return Robot;
    }

    public SetViewpoint SetViewpointRobot(String Robot)
    {
        this.Robot = Robot;
        return this;
    }
    /*
     * IP address: NOTE: USARSim doesn’t support the loopback ip address. Please
     * don’t use “127.0.0.1” as the parameter.
     */
    protected String Client = null;

    public String getClient()
    {
        return Client;
    }

    public SetViewpoint SetViewpointClient(String Client)
    {
        this.Client = Client;
        return this;
    }

    /////// Properties END
    /////// Extra Java code BEGIN
    /////// Additional code from xslt BEGIN
    /////// Additional code from xslt END
    /////// Extra Java from XML BEGIN
    /////// Extra Java from XML END
    /////// Extra Java code END
    /**
     * Cloning constructor.
     */
    public SetViewpoint(SetViewpoint original)
    {
        this.Name = original.Name;
        this.Robot = original.Robot;
        this.Client = original.Client;
    }

    @Override
    public String toString()
    {
        return toMessage();
    }

    public String toHtmlString()
    {
        return super.toString()
                + "<b>Type</b> : "
                + String.valueOf(Type)
                + " <br/> "
                + "<b>Robot</b> : "
                + String.valueOf(Robot)
                + " <br/> "
                + "<b>Name</b> : "
                + String.valueOf(Name)
                + " <br/> "
                + "<b>Client</b> : "
                + String.valueOf(Client)
                + " <br/> "
                + "";
    }

    public String toMessage()
    {

        StringBuilder buf = new StringBuilder();
        buf.append("SET");

        if(Type != null)
        {
            buf.append(" {Type ").append(Type).append("}");
        }

        if(Robot != null)
        {
            buf.append(" {Robot ").append(Robot).append("}");
        }

        if(Name != null)
        {
            buf.append(" {Name ").append(Name).append("}");
        }

        if(Client != null)
        {
            buf.append(" {Client ").append(Client.toString()).append("}");
        }


        return buf.toString();
    }
}
