package cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands;

import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.base3d.worldview.object.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * Message you'll send at the beginning of the communication to create a robot
 * in the game. You must send this message before you can have a character to
 * play in the game.
 *
 * Corresponding GameBots command is INIT.
 *
 */
public class Initialize extends CommandMessage
{
    public Initialize(String ClassName, String Name, Location Location, Rotation Rotation, String Skin, String Team)
    {
        this.ClassName = ClassName;
        this.Name = Name;
        this.Location = Location;
        this.Rotation = Rotation;
        this.Skin = Skin;
        this.Team = Team;
    }

    public Initialize(String ClassName, String Name, Location Location, Rotation Rotation)
    {
        this.ClassName = ClassName;
        this.Name = Name;
        this.Location = Location;
        this.Rotation = Rotation;
    }

    public Initialize(String ClassName, String Name, String StringLocation, String Skin, String Team)
    {
        this.ClassName = ClassName;
        this.Name = Name;
        this.StartPosition = StringLocation;
        this.Skin = Skin;
        this.Team = Team;
    }

    public Initialize(String ClassName, String Name, String StringLocation)
    {
        this.ClassName = ClassName;
        this.Name = Name;
        this.StartPosition = StringLocation;
    }

    /**
     * <p></p>WARNING: this is empty-command constructor, you have to use
     * setters to fill it up!
     */
    public Initialize()
    {
    }
    /////// Properties BEGIN
    /*
     * the class name of the 67robot. It can be USARBot.ATRVJr, USARBot.Zerg,
     * USARBot.P2AT, USARBot.P2DX, USARBot.Hummer, and any other robots built by
     * the user.
     */
    protected String ClassName = null;

    public String getClassName()
    {
        return ClassName;
    }

    public Initialize setClassName(String ClassName)
    {
        this.ClassName = ClassName;
        return this;
    }
    /**
     * Robot name.
     */
    protected String Name = null;

    public String getName()
    {
        return Name;
    }

    public Initialize setName(String Name)
    {
        this.Name = Name;
        return this;
    }
    /*
     * the start position of the robot in meters from the world origin. For
     * different arenas, we need different positions. The recommended positions
     * are listed on Table 2 for the USAR arenas. Recommended start locations
     * for worlds are given in a text file that is included with the world
     * download. Worlds are available in the “maps” file release area on
     * sourceforge.
     */
    protected Location Location = null;

    public Location getLocation()
    {
        return Location;
    }

    public Initialize setLocation(Location Location)
    {
        this.Location = Location;
        return this;
    }
    //user can set the location by string which he can get from the STARTPOSES command(for example {Location RobotStart1}) -- misleading: use {Start StartPosition} to propperly use String Location INIT
    protected String StartPosition = null;

    public String getStartPosition()
    {
        return StartPosition;
    }
    protected Rotation Rotation = null;

    public Rotation getRotation()
    {
        return Rotation;
    }

    public Initialize setRotation(Rotation Rotation)
    {
        this.Rotation = Rotation;
        return this;
    }
    //ADDED for full support of init command!
    //Skin can be RED or BLUE for example ERS supports skins
    protected String Skin = null;

    public String getSkin()
    {
        return Skin;
    }
    protected String Team = null;

    public String getTeam()
    {
        return Team;
    }

    /////// Properties END
    /////// Extra Java code BEGIN
    /////// Additional code from xslt BEGIN
    /////// Additional code from xslt END
    /////// Extra Java from XML BEGIN
    /////// Extra Java from XML END
    /////// Extra Java code END
    /**
     * Cloning constructor.
     */
    public Initialize(Initialize original)
    {
        this.Name = original.Name;
        this.Location = original.Location;
        this.ClassName = original.ClassName;
        this.StartPosition = original.StartPosition;
        this.Skin = original.Skin;
        this.Team = original.Team;
        this.Rotation = original.Rotation;
    }

    @Override
    public String toString()
    {
        return toMessage();

    }

    public String toHtmlString()
    {
        return super.toString()
                + "<b>ClassName</b> : "
                + String.valueOf(ClassName)
                + " <br/> "
                + "<b>Name</b> : "
                + String.valueOf(Name)
                + " <br/> "
                + "<b>Location</b> : "
                + String.valueOf(Location)
                + " <br/> "
                + "<b>Start</b> : "
                + String.valueOf(StartPosition)
                + " <br/> "
                + "<b>Skin</b> : "
                + String.valueOf(Skin)
                + " <br/> "
                + "<b>Team</b> : "
                + String.valueOf(Team)
                + " <br/> "
                + "<b>Rotation</b> : "
                + String.valueOf(Rotation)
                + " <br/> "
                + "";
    }

    public String toMessage()
    {

        StringBuilder buf = new StringBuilder();
        buf.append("INIT");
        if(ClassName != null)
        {
            buf.append(" {ClassName ").append(ClassName).append("}");
        }

        if(Name != null)
        {
            buf.append(" {Name ").append(Name).append("}");
        }

        if(Location != null)
        {
            buf.append(" {Location ").append(Location.getX()).append(",").append(Location.getY()).append(",").append(Location.getZ()).append("}");
        }

        if(StartPosition != null)
        {
            buf.append(" {Start ").append(StartPosition).append("}");
        }

        if(Rotation != null)
        {
            buf.append(" {Rotation ").append(Rotation.getRoll()).append(",").append(Rotation.getPitch()).append(",").append(Rotation.getYaw()).append("}");
        }

        if(Skin != null)
        {
            buf.append(" {Skin ").append(Skin).append("}");
        }

        if(Team != null)
        {
            buf.append(" {Team ").append(Team).append("}");
        }
        return buf.toString();
    }
}
