package cz.cuni.amis.pogamut.usar2004.agent.module.state;

import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.LinkState;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.MissionPackageMessage;
import java.util.List;

/**
 * State message representative for Mission package.
 *
 * @author vejmanm
 */
public class MissionPackageState
{
    protected MissionPackageMessage lastMessage;

    public MissionPackageState()
    {
    }

    /**
     * Method used for updating the message object that provides particular
     * properties for given type. Note that this object is created by yylex
     * parser and contains properties for all configuration subject types. But
     * only relevat to individual Config Subject are filled.
     *
     * @param message Mission package message from server.
     */
    public void updateMessage(MissionPackageMessage message)
    {
        lastMessage = message;
    }

    /**
     * Timestamp form the UT since server start in seconds.
     *
     * @return Returns seconds elapsed from the start of the server.
     */
    public double getTime()
    {
        return lastMessage.getTime();
    }

    /**
     * Used to make sure the object is filled.
     *
     * @return Returns true if the object is filled with State message.
     */
    public Boolean isReady()
    {
        return (lastMessage != null);
    }

    /**
     * Name of the mission package
     *
     * @return; Returns the name of the mission package
     */
    public String getName()
    {
        return lastMessage.getName();
    }

    /**
     * This parameter gives the link number that will be described by the next
     * two parameters (Value and Torque). Please note that you will have as many
     * as these parameters as you have links.
     *
     * VALUE parameter has two possible meanings. If the link being described is
     * a prismatic joint, double gives the distance (in meters) from the
     * original position of the link. If the link being described is a revolute
     * joint, it gives a sector(probably).
     *
     * The TORQUE parameter gives the current torque of the link being
     * described. * All of the above are collected into one data structure below
     * this text.
     *
     * @return Returns collection of Link States.
     */
    public List<LinkState> GetLinkStateList()
    {
        return lastMessage.getLinkStateSet();
    }
}