package cz.cuni.amis.pogamut.usar2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;

/**
 * Sensor message representative for INS sensor.
 *
 * @author vejmanm
 */
public class SensorINS extends SuperSensor
{
    //public static final String type="INS";
    public static final SensorType type = SensorType.INS_SENSOR;

    /**
     * Ctor. Sensor type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public SensorINS()
    {
        super(type);
    }

    /**
     * Location used by INS sensor to determine robots location.
     *
     * @return Returns Location from INS sensor.
     */
    public Location getLocation()
    {
        return lastMessage.getLocations().get(0);
    }

    /**
     * INS sensor entry in USARSim manual v3.1.3 suggests that it should need
     * more than one record of Orienation, but the experience was different.
     * Still we use list of Rotations to support multiple entry. Mainly used for
     * determination of robots Orientation. Here we offer only the first Record.
     *
     * @return Returns Rotation from INS sensor.
     */
    public Rotation getOrientation()
    {
        return lastMessage.getOrientations().get(0);
    }
}
