/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.usar2004.samples.AirScanner;

/**
 * List of all Robot states. Each state represents on type of behaviour
 * associated with this state
 *
 * @author vejmanm
 */
public enum State
{
    DEFAULT,//initial - find closest corner
    LONGFORTH,//long way
    SHORTFORTH,//short way
    LONGBACK,//long way backwards
    SHORTBACK,//short as well
    TERMINATE,//return home and end
    LAND,//fall
    CHARGE,//return to base
    CHARGING,//fall down, reconfigure, wait one moment
    AVOIDING,//reactive avoiding obstacles
    AVOIDED,//got to the point that leaded away from an obstacle
    CONTINUE,//Get back to the position before charge was required
    CONTINUED;//continue in scanning

    public static State getNextState(State current)
    {
        switch(current)
        {
            case DEFAULT:
                return LONGFORTH;
            case LONGFORTH:
                return SHORTFORTH;
            case SHORTFORTH:
                return LONGBACK;
            case LONGBACK:
                return SHORTBACK;
            case SHORTBACK:
                return LONGFORTH;
            case TERMINATE:
                return LAND;
            case LAND:
                return LAND;
            case CHARGE:
                return CHARGING;
            case CHARGING:
                return CHARGING;
            case CONTINUE:
                return CONTINUED;
            case AVOIDING:
                return AVOIDED;
            default:
                return DEFAULT;
        }
    }
}
