package cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands;

import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * This command is used to drive a joint.
 *
 *
 *
 * Corresponding GameBots command is SET.
 *
 */
public class SetJoint extends CommandMessage
{
    //constructor for the joints
    public SetJoint(String Type, String Name, String Opcode, double param1, double param2)
    {
        this.Type = Type;
        this.Name = Name;
        this.Opcode = Opcode;
        this.Param1 = param1;
        this.Param2 = param2;
    }

    /**
     * <p></p>WARNING: this is empty-command constructor, you have to use
     * Setters to fill it up!
     */
    public SetJoint()
    {
    }
    /////// Properties BEGIN
    protected String Type = "Joint";

    public String getType()
    {
        return Type;
    }
    protected String Name = null;

    public String getName()
    {
        return Name;
    }

    public SetJoint setName(String Name)
    {
        this.Name = Name;
        return this;
    }
    /*
     * the operation code. The available codes are: ‘Angle’ or ‘0’: set the
     * extra angle in radian the joint will move. ‘Velocity’ or ‘1’: set the
     * spin speed in radian per second for the joint. ‘Torque’ or ‘2’: set the
     * torque applied on the joint.
     */
    protected String Opcode = null;

    public String getOpcode()
    {
        return Opcode;
    }

    public SetJoint setOpcode(String Opcode)
    {
        this.Opcode = Opcode;
        return this;
    }
    //Corresponds with the Opcode
    protected double Param1 = 0;

    public double getParam1()
    {
        return Param1;
    }

    public SetJoint setParam1(double Param1)
    {
        this.Param1 = Param1;
        return this;
    }
    //Optional parameter, only uses for the KCarWheelJoint to set the steer angle
    protected double Param2 = 0;

    public double getParam2()
    {
        return Param2;
    }

    public SetJoint setParam2(double Param2)
    {
        this.Param2 = Param2;
        return this;
    }

    /*
     * Example 1: SET {Type Joint} {Name UpperArm} {Opcode Angle} {Params 1.25}
     * Example 2: SET {Type Gripper} {Name Gripper} {Opcode Open} {Params 0.8}
     */
    /////// Properties END
    /////// Extra Java code BEGIN
    /////// Additional code from xslt BEGIN
    /////// Additional code from xslt END
    /////// Extra Java from XML BEGIN
    /////// Extra Java from XML END
    /////// Extra Java code END
    /**
     * Cloning constructor.
     */
    public SetJoint(SetJoint original)
    {
        this.Name = original.Name;
        this.Opcode = original.Opcode;
        this.Param1 = original.Param1;
        this.Param2 = original.Param2;
    }

    @Override
    public String toString()
    {
        return toMessage();
    }

    public String toHtmlString()
    {
        return super.toString()
                + "<b>Type</b> : "
                + String.valueOf(Type)
                + " <br/> "
                + "<b>Name</b> : "
                + String.valueOf(Name)
                + " <br/> "
                + "<b>Opcode</b> : "
                + String.valueOf(Opcode)
                + " <br/> "
                + "<b>Param1</b> : "
                + String.valueOf(Param1)
                + " <br/> "
                + "<b>Param2</b> : "
                + String.valueOf(Param2)
                + " <br/> "
                + "";

    }

    public String toMessage()
    {

        StringBuilder buf = new StringBuilder();
        buf.append("SET");

        if(Type != null)
        {
            buf.append(" {Type ").append(Type).append("}");
        }

        if(Name != null)
        {
            buf.append(" {Name ").append(Name).append("}");
        }

        if(Opcode != null)
        {
            buf.append(" {Opcode ").append(Opcode).append("}");
        }

        if(Opcode != null)
        {
            buf.append(" {Params ").append(Param1).append(",").append(Param2).append("}");
        }


        return buf.toString();
    }
}
