package cz.cuni.amis.pogamut.usar2004.agent.module.nfo;

import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;

/**
 * Nfo message representative for Begin info of current level.
 *
 * @author vejmanm
 */
public class NfoBeginMapInfo extends SuperNfo
{
    /**
     * Ctor. Nfo type describes particular subject about which we want to know
     * about. It is used to distinguish incoming message from the server.
     *
     * @param bot USAR2004Bot variable for filling base class.
     */
    public NfoBeginMapInfo(USAR2004Bot bot)
    {
        super(bot, "MapInfo");
    }

    /**
     * Initial NFO message recieved from the server will provide information
     * such as Time Limit.
     *
     * @return Returns the time limit for current map.
     */
    public double getTimeLimit()
    {
        return lastMessage.getTimeLimit();
    }

    /**
     * Initial NFO message recieved from the server will provide information
     * such as Level Name.
     *
     * @return Returns name of current map.
     */
    public String getLevel()
    {
        return lastMessage.getLevel();
    }

    /**
     * Initial NFO message recieved from the server will provide information
     * such as Game Type.
     *
     * @return Returns a Unreal type of current game.
     */
    public String getGameType()
    {
        return lastMessage.getGameType();
    }
}
