package cz.cuni.amis.pogamut.usar2004.agent.module.geometry;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.GeometryType;

/**
 * Geometry message representative for Ground vehicles.
 *
 * @author vejmanm
 */
public class GeoGround extends VehicleGeometry
{
    public static final GeometryType type = GeometryType.GROUND_VEHICLE;

    /**
     * Ctor. Geometry type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public GeoGround()
    {
        super(type);
    }

    /**
     * The value is the radius of the robot’s wheels, in meters
     *
     * @return Returns wheel radius of the robot.
     */
    public double getWheelRadius()
    {
        return lastMessage.getWheelRadius();
    }

    /**
     * The value is the wheel separation, in meters. The wheel separation
     * defines the distance between two wheels along the length (x axis) of the
     * robot’s chassis.
     *
     * @return Returns wheel separation of the robot.
     */
    public double getWheelSeparation()
    {
        return lastMessage.getWheelSeparation();
    }

    /**
     * The value is the wheel base, in meters. The wheel base defines the
     * distance between two wheels along the width (y axis) of the robot’s
     * chassis
     *
     * @return Retursn wheel base of the robot.
     */
    public double getWheelBase()
    {
        return lastMessage.getWheelBase();
    }
}
