package cz.cuni.amis.pogamut.usar2004.agent.module.datatypes;

import cz.cuni.amis.pogamut.usar2004.agent.module.state.SuperState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Container of state particular state messages.
 *
 * @author vejmanm
 */
public class StateContainer extends HashMap<String, SuperState>
{
    /**
     * Gets state message representative from local hashmap. Returns null if
     * none matches.
     *
     * @param type String representation of state type.
     * @return Returns specific state message matching input string <b>type</b>
     */
    public SuperState getStatesByType(String type)
    {
        if(this.isEmpty() || type == null)
        {
            return null;
        }
        if(this.containsKey(type))
        {
            return this.get(type);
        }
        return null;
    }

    /**
     * Iterates through local hashmap values and seeks match. Note that every
     * SuperState offspring has its own VehicleType property. Returns null if
     * none matches.
     *
     * @param type VehicleType representation of state type - easier to use
     * since we don't have to watch after propper spelling.
     * @return Returns specific state message matching input VehicleType
     * <b>type</b>
     */
    public SuperState getStatesByVehicleType(VehicleType type)
    {
        if(this.isEmpty() || type == null)
        {
            return null;
        }
        for(SuperState state : this.values())
        {
            if(state == null)
            {
                continue;
            }
            if(state.getVehicleType() == type)
            {
                return state;
            }
        }
        return null;
    }

    /**
     *
     * Iterates through local hahmap values and takes note of every SuperState
     * object that is Instance of specified class. Returns null if none matches
     * or <b>c</b> is null.
     *
     * @param c <B>c</B> is class that the state message should extend, So when
     * SuperState is inserted as c, it should return list of all types of
     * vehicles that this holds data of.
     * @return Returns list of state objects that implements class <B>c</B>
     */
    public List<SuperState> getStatesByClass(Class c)
    {
        if(c == null)
        {
            return null;
        }
        List<SuperState> list = new ArrayList<SuperState>();
        for(SuperState sensor : this.values())
        {
            if(c.isInstance(sensor))
            {
                list.add(sensor);
            }
        }
        return list;
    }

    /**
     * Returns list of availible state object names.
     *
     * @return Returns list of availible state object names.
     */
    public List<String> getAvailibleTypes()
    {
        if(this.isEmpty())
        {
            return null;
        }
        List<String> list = new ArrayList<String>();
        for(String type : this.keySet())
        {
            list.add(type);
        }
        return list;
    }
}
