package cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands;

import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * This command is used to manage the viewports.
 *
 *
 *
 *
 * When USARSim initially starts up, users can freely move around the world
 * using the mouse and keyboard. Pressing the left mouse button of the mouse
 * attaches the view to the robot’s viewport controller. The robot viewport
 * controller currently supports two configurations: SingleView and QuadView.
 * The SingleView configuration provides users with a single view coming from a
 * single camera. The QuadView configuration provides user with four views,
 * giving them the possibility of viewing up to four cameras simultaneously (the
 * screen is divided up into four equal portions, each of which is used for a
 * camera). When a robot is added to a world, the viewport configuration is
 * automatically set to accommodate for the maximum number of cameras. In other
 * words, if a robot has zero or one camera, it will automatically start in
 * SingleView; otherwise, it will automatically start in QuadView. Since a robot
 * might have more than four cameras and users might want to cycle through all
 * the cameras using SingleView, USARSim gives the possibility of configuring
 * the viewports
 *
 *
 *
 * Corresponding GameBots command is SET.
 *
 */
public class SetViewports extends CommandMessage
{
    //constructor for the viewports
    public SetViewports(String Config, String Viewport1, String Viewport2, String Viewport3, String Viewport4)
    {
        this.Config = Config;
        this.Viewport1 = Viewport1;
        this.Viewport2 = Viewport2;
        this.Viewport3 = Viewport3;
        this.Viewport4 = Viewport4;
    }

    /**
     * <p></p>WARNING: this is empty-command constructor, you have to use
     * Setters to fill it up!
     */
    public SetViewports()
    {
    }
    /////// Properties BEGIN
    protected String Type = "Viewports";

    public String getType()
    {
        return Type;
    }
    /*
     * This parameter defines the viewports’ configuration. It can be one of two
     * values: 73“0” or “SingleView” for one viewport. “1” or “QuadView” for
     * four viewports.
     */
    protected String Config = null;

    public String getConfig()
    {
        return Config;
    }

    public SetViewports setConfig(String Config)
    {
        this.Config = Config;
        return this;
    }
    /*
     * the name of the camera that will be attached to viewport 1. Optionally,
     * ‘string’ can be set to “Disable” to disable viewport 1. Viewport 1 is the
     * only viewport in “SingleView” and the Top-Left viewport in “QuadView”.
     */
    protected String Viewport1 = null;

    public String getViewport1()
    {
        return Viewport1;
    }

    public SetViewports setViewport1(String Viewport1)
    {
        this.Viewport1 = Viewport1;
        return this;
    }
    /*
     * the name of the camera that will be attached to viewport 2. Optionally,
     * ‘string’ can be set to “Disable” to disable viewport 2. Viewport 2 is the
     * Top-Right viewport in “QuadView”.
     */
    protected String Viewport2 = null;

    public String getViewport2()
    {
        return Viewport2;
    }

    public SetViewports setViewport2(String Viewport2)
    {
        this.Viewport2 = Viewport2;
        return this;
    }
    /*
     * the name of the camera that will be attached to viewport 3. Optionally,
     * ‘string’ can be set to “Disable” to disable viewport 3. Viewport 3 is the
     * Bottom-Left viewport in “QuadView”.
     */
    protected String Viewport3 = null;

    public String getViewport3()
    {
        return Viewport3;
    }

    public SetViewports setViewport3(String Viewport3)
    {
        this.Viewport3 = Viewport3;
        return this;
    }
    /*
     * the name of the camera that will be attached to viewport 4. Optionally,
     * ‘string’ can be set to “Disable” to disable viewport 4. Viewport 4 is the
     * Bottom-Right viewport in “QuadView”.
     */
    protected String Viewport4 = null;

    public String getViewport4()
    {
        return Viewport4;
    }

    public SetViewports setViewport4(String Viewport4)
    {
        this.Viewport4 = Viewport4;
        return this;
    }

    /*
     * Example: SET {Type Viewports} {Config QuadView} SET {Type Viewports}
     * {Config QuadView} {Viewport1 Camera1} {Viewport2 Camera2} {Viewport3
     * Disable} {Viewport4 Disable} SET {TypeViewports} {Viewport1 Disable}
     */
    /////// Properties END
    /////// Extra Java code BEGIN
    /////// Additional code from xslt BEGIN
    /////// Additional code from xslt END
    /////// Extra Java from XML BEGIN
    /////// Extra Java from XML END
    /////// Extra Java code END
    /**
     * Cloning constructor.
     */
    public SetViewports(SetViewports original)
    {
        this.Config = original.Config;
        this.Viewport1 = original.Viewport1;
        this.Viewport2 = original.Viewport2;
        this.Viewport3 = original.Viewport3;
        this.Viewport4 = original.Viewport4;
    }

    @Override
    public String toString()
    {
        return toMessage();
    }

    public String toHtmlString()
    {
        return super.toString()
                + "<b>Type</b> : "
                + String.valueOf(Type)
                + " <br/> "
                + "<b>Config</b> : "
                + String.valueOf(Config)
                + " <br/> "
                + "<b>Config</b> : "
                + String.valueOf(Config)
                + " <br/> "
                + "<b>ViewPort1</b> : "
                + String.valueOf(Viewport1)
                + " <br/> "
                + "<b>ViewPort2</b> : "
                + String.valueOf(Viewport2)
                + " <br/> "
                + "<b>ViewPort3</b> : "
                + String.valueOf(Viewport3)
                + " <br/> "
                + "<b>ViewPort4</b> : "
                + String.valueOf(Viewport4)
                + " <br/> "
                + "";
    }

    public String toMessage()
    {

        StringBuilder buf = new StringBuilder();
        buf.append("SET");

        if(Type != null)
        {
            buf.append(" {Type ").append(Type).append("}");
        }

        if(Config != null)
        {
            buf.append(" {Config ").append(Config).append("}");
        }

        if(Viewport1 != null)
        {
            buf.append(" {Viewport1 ").append(Viewport1).append("}");
        }

        if(Viewport2 != null)
        {
            buf.append(" {Viewport2 ").append(Viewport2).append("}");
        }

        if(Viewport3 != null)
        {
            buf.append(" {Viewport3 ").append(Viewport3).append("}");
        }

        if(Viewport4 != null)
        {
            buf.append(" {Viewport4 ").append(Viewport4).append("}");
        }
        return buf.toString();
    }
}
