package cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands;

import java.util.*;
import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * This is Multidrive message as a addition to Drive command
 *
 * Corresponding GameBots command is MULTIDRIVE.
 *
 */
public class Multidrive extends CommandMessage
{
    public Multidrive(String[] Names, String[] Values)
    {
        if((Names.length == Values.length))
        {
            for(int i = 0; i < Names.length; i++)
            {
                this.NameValues.put(Names[i], Values[i]);
            }
        }
    }

    public Multidrive(String Name, String Value)
    {
        this.NameValues.put(Name, Value);
    }

    /**
     * <p></p>WARNING: this is empty-command constructor, you have to use
     * setters to fill it up!
     */
    public Multidrive()
    {
    }
    /////// Properties BEGIN
    //Map of name/value couples.
    protected Map<String, String> NameValues = new HashMap<String, String>();

    public Map<String, String> getNameValues()
    {
        return NameValues;
    }

    public Multidrive setNameValues(Map<String, String> NameValues)
    {
        this.NameValues = NameValues;
        return this;
    }

    public Multidrive addNameValue(String Name, String Value)
    {
        this.NameValues.put(Name, Value);
        return this;
    }

    /////// Properties END
    /////// Extra Java code BEGIN
    /////// Additional code from xslt BEGIN
    /////// Additional code from xslt END
    /////// Extra Java from XML BEGIN
    /////// Extra Java from XML END
    /////// Extra Java code END
    /**
     * Cloning constructor.
     */
    public Multidrive(Multidrive original)
    {


        this.NameValues.putAll(original.NameValues);

    }

    @Override
    public String toString()
    {
        return toMessage();
    }

    public String toHtmlString()
    {
        return super.toString()
                + "";
    }

    public String toMessage()
    {
        StringBuilder buf = new StringBuilder();
        buf.append("MULTIDRIVE");


        if(!NameValues.isEmpty())
        {
            Iterator it = NameValues.entrySet().iterator();
            while(it.hasNext())
            {
                Map.Entry en = (Map.Entry) it.next();
                buf.append(" {").append(en.getKey()).append(" ").append(en.getValue()).append("}");
            }
        }

        return buf.toString();
    }
}
