package cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes;

import java.io.Serializable;

/**
 * Odometry pose is the estimated robot position relative to the start point in
 * meters. ‘theta’ is the head angle in radians relative to the start
 * orientation. This class is used for storing data from Odometry Sensor.
 *
 * @author vejmanm
 */
public class OdometryPose implements Serializable, Cloneable
{
    private double x = 0;
    private double y = 0;
    private double theta = 0;

    public OdometryPose()
    {
    }

    public OdometryPose(double x, double y, double theta)
    {
        this.x = x;
        this.y = y;
        this.theta = theta;
    }

    public double getX()
    {
        return x;
    }

    public double getY()
    {
        return y;
    }

    public double getTheta()
    {
        return theta;
    }

    public final void set(double x, double y, double theta)
    {
        this.x = x;
        this.y = y;
        this.theta = theta;

    }

    public final void set(OdometryPose tplOP)
    {
        this.x = tplOP.x;
        this.y = tplOP.y;
        this.theta = tplOP.theta;
    }

    @Override
    public Object clone()
    {
        return new OdometryPose(x, y, theta);
    }
}
