package cz.cuni.amis.pogamut.usar2004.communication.translator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;


/**
 * Translator context serves as the context during the FSM work. It provides respective fsm states an access
 * to the instances of:
 * <ul>
 * <li>event queue - object where we're sending new world events</li>
 * <li>item translator - an object with factories of respective items</li>
 * <li>log</li>
 * </ul>
 * <p><p>
 * WARNING: the same context is used for Bot, ControlServer as well as Observer!
 *
 * @author Jimmy
 */
public class USARTranslatorContext {

    private IWorldEventQueue events;
    private Logger log;

    public USARTranslatorContext(IWorldEventQueue events, Logger log) {
        this.events = events;
        this.log = log;
    }

    public void reset() {

    }

    public IWorldEventQueue getEventQueue() {
        return events;
    }



    public Logger getLogger() {
    	return log;
    }



}
