package cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands;

import java.util.*;
import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * A mission package is constructed of a series of connected elements. Of
 * course, we can control the joints one by one to set the mission package’s
 * pose. Here, we provide another command to directly set the package’s terminal
 * pose and let USARSim control every element’s joint for us. If a camera is
 * mounted on a pan/tilt mission package, we can use this command to control the
 * camera’s pose. Using mission package control commands, we can have multiple
 * cameras and control them separately.
 *
 * Corresponding GameBots command is MISPGK.
 *
 * TIPS: Pan/tilt mission packages enable the use of multiple cameras with
 * independent control on each of them.
 */
public class MissionPackage extends CommandMessage
{
    public MissionPackage(String Name, int[] Links, double[] Values, int[] Orders)
    {

        this.Name = Name;

        if((Links.length == Values.length) && (Links.length == Orders.length))
        {
            for(int i = 0; i < Links.length; i++)
            {
                this.Links.add(Links[i]);
                this.Values.add(Values[i]);
                this.Orders.add(Orders[i]);
            }
        }
    }

    public MissionPackage(String Name, int Link, double Value, int Order)
    {
        this.Name = Name;
        this.Links.add(Link);
        this.Orders.add(Order);
        this.Values.add(Value);
    }

    public MissionPackage(String Name, int Link, double Value)
    {
        this.Name = Name;
        this.Links.add(Link);
        this.Orders.add(0);
        this.Values.add(Value);
    }

    /**
     * <p></p>WARNING: this is empty-command constructor, you have to use
     * setters to fill it up!
     */
    public MissionPackage()
    {
    }
    /////// Properties BEGIN
    //the joint name
    protected String Name = null;

    public String getName()
    {
        return Name;
    }

    public MissionPackage setName(String Name)
    {
        this.Name = Name;
        return this;
    }
    //the link number that will be moved using the next parameters
    protected List<Integer> Links = new ArrayList<Integer>();

    public List<Integer> getLinks()
    {
        return Links;
    }

    public void addLink(int link)
    {
        this.Links.add(link);
    }

    public void addLink(int[] links)
    {
        for(int f : links)
        {
            this.Links.add(f);
        }
    }
    /*
     * value used to move the link. What this parameter describes depends on the
     * order given. If the order is 0, ‘double’ is the absolute angle, in
     * radians, for a revolute joint or the distance, in meters, for a prismatic
     * joint. If the order is 1, ‘double’ is the velocity, in m/s. If the order
     * is 2, ‘double’ is the torque.
     */
    protected List<Double> Values = new ArrayList<Double>();

    public List<Double> getValues()
    {
        return Values;
    }

    public void addValue(double value)
    {
        this.Values.add(value);
    }

    public void addValue(double[] values)
    {
        for(double f : values)
        {
            this.Values.add(f);
        }
    }
    /*
     * optional (0 by default) and indicates the control mode. ‘0’ means angle
     * control, ‘1’ means speed control, and ‘2’ means torque control.
     */
    protected List<Integer> Orders = new ArrayList<Integer>();

    //{Order int} ‘int’ is optional (0 by default) and indicates the control mode. ‘0’ means angle control, ‘1’ means speed control, and ‘2’ means torque control. 
    public List<Integer> getOrders()
    {
        return Orders;
    }

    public void addOrder(int order)
    {
        this.Orders.add(order);
    }

    public void addOrder(int[] orders)
    {
        for(int f : orders)
        {
            this.Orders.add(f);
        }
    }

    /*
     * Example: MISPKG {Name CameraPanTilt} {Link 1} {Value 1.5} {Link 2} {Value
     * 0} MISPKG {Name TalonArm} {Link 1} {Value 0.70} {Link 3} {Value 0.1}
     * {Order 1}
     */
    /////// Properties END
    /////// Extra Java code BEGIN
    /////// Additional code from xslt BEGIN
    /////// Additional code from xslt END
    /////// Extra Java from XML BEGIN
    /////// Extra Java from XML END
    /////// Extra Java code END
    /**
     * Cloning constructor.
     */
    public MissionPackage(MissionPackage original)
    {
        this.Name = original.Name;
        this.Links.addAll(original.Links);
        this.Values.addAll(original.Values);
        this.Orders.addAll(original.Orders);
    }

    @Override
    public String toString()
    {
        return toMessage();
    }

    public String toHtmlString()
    {

        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());



        buf.append("<b>Name</b> : ").append(String.valueOf(Name)).append(" <br/> ");

        if((!Links.isEmpty()) && (Links.size() == Values.size()) && (Links.size() == Orders.size()))
        {
            for(int i = 0; i < Links.size(); i++)
            {

                buf.append("<b>Link</b> : "
                        + String.valueOf(Links.get(i))
                        + " <br/> "
                        + "<b>Value</b> : "
                        + String.valueOf(Values.get(i))
                        + " <br/> "
                        + "<b>Order</b> : "
                        + String.valueOf(Orders.get(i))
                        + " <br/> ");
            }
        }

        return buf.toString();
    }

    public String toMessage()
    {
        StringBuilder buf = new StringBuilder();
        buf.append("MISPKG");

        if(Name != null)
        {
            buf.append(" {Name ").append(Name).append("}");
        }

        if((!Links.isEmpty()) && (Links.size() == Values.size()) && (Links.size() == Orders.size()))
        {
            for(int i = 0; i < Links.size(); i++)
            {
                buf.append(" {Link ").append(Links.get(i)).append("}");
                buf.append(" {Value ").append(Values.get(i)).append("}");
                buf.append(" {Order ").append(Orders.get(i)).append("}");
            }
        }

        return buf.toString();
    }
}
