package cz.cuni.amis.pogamut.usar2004.agent.module.logic;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.google.inject.Inject;

import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReact;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReactOnce;
import cz.cuni.amis.pogamut.base.communication.worldview.react.ObjectEventReactOnce;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.NfoMessage;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.StateMessage;

import cz.cuni.amis.utils.flag.Flag;

public class USAR2004BotLogic<BOT extends USAR2004Bot> extends LogicModule<BOT> {

    /** by default we will call logic method 5 times per second */
    private static final int DEFAULT_USAR_LOGIC_FREQUENCY = 5;
    
    private EventReactOnce<NfoMessage> gameInfoReaction;
    private EventReactOnce<StateMessage> stateMessageReaction;
    private BusAwareCountDownLatch latch;
    private Flag<Boolean> gameInfoCame = new Flag<Boolean>(false);
    private Flag<Boolean> stateMessageCame = new Flag<Boolean>(false);

    @Inject
    public USAR2004BotLogic(BOT agent, IAgentLogic logic) {
        this(agent, logic, null, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(agent.getWorldView()));
    }

    public USAR2004BotLogic(BOT agent, IAgentLogic logic, Logger log) {
        this(agent, logic, log, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(agent.getWorldView()));
    }

    public USAR2004BotLogic(BOT agent, IAgentLogic logic, Logger log, ComponentDependencies dependencies) {
        super(agent, logic, log, dependencies);
        gameInfoReaction = new EventReactOnce<NfoMessage>(NfoMessage.class, agent.getWorldView()) {

            @Override
            protected void react(NfoMessage event) {
		gameInfoCame.setFlag(true);

              }
        };

        stateMessageReaction = new EventReactOnce<StateMessage>(StateMessage.class, agent.getWorldView()) {

            @Override
            protected void react(StateMessage event) {
                synchronized (stateMessageCame) {
                    stateMessageCame.setFlag(true);
                    latch.countDown();
                }
            }
        };
        cleanUp();
    }

    @Override
    protected void logicLatch(String threadName) {
        super.logicLatch(threadName);
        //System.out.println("USAR2004BotLogic.logicLatch()");
        if (log.isLoggable(Level.FINE)) {
            log.fine(threadName + ": Waiting for the first State message.");
        }
        if (!latch.await(120, TimeUnit.SECONDS)) {
            throw new ComponentCantStartException("State message was not received in 120secs.", this);
        }
        if (log.isLoggable(Level.INFO)) {
            log.info(threadName + ": First STATE message received, starting logic cycles.");
        }

        if (!gameInfoCame.getFlag()) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning(threadName + ": GAMEINFO (NFO) message DID NOT COME! Even though State message has been received. Was it disabled in USARSim2004.ini? Or is it a bug... ?");
            }
        }
    }

    @Override
    protected void start(boolean startPaused) throws AgentException {
        super.start(startPaused);

        //logic frequency set by default in USARSim, how many times per sec will the logic method be called
        setLogicFrequency(DEFAULT_USAR_LOGIC_FREQUENCY);
        
        // this is synchronized also in EndMessage listener, we must not allow the situation
        // 1. END MESSAGE CAME
        // 2. thread1: fires EndMessageListener
        // 3. thread2: start() is called
        // 4. thread1: calls latch.countDown on old version of the latch
        // 5. thread2: latch is initialized
        // ... FIRST END MESSAGE IS TOTALLY MISSED, LOGIC WON'T START!
        synchronized (stateMessageCame) {
            latch = new BusAwareCountDownLatch(1, agent.getEventBus(), agent.getWorldView().getComponentId());
            if (stateMessageCame.getFlag()) {
                latch.countDown();
            }
        }
        //System.out.println("USAR2004BotLogic.start()");
    }

    @Override
    protected void cleanUp() throws AgentException {
        super.cleanUp();
        //System.out.println("USAR2004BotLogic.cleanUp()");
        gameInfoCame.setFlag(false);
        gameInfoReaction.enable();
        stateMessageReaction.enable();
        stateMessageCame.setFlag(false);
    }
}
