package cz.cuni.amis.pogamut.usar2004.utils;

import java.util.List;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.utils.runner.impl.AgentRunner;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.PogamutPlatform;
import cz.cuni.amis.pogamut.base.utils.PogamutProperty;
import cz.cuni.amis.pogamut.usar2004.agent.IUSAR2004BotController;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.params.USAR2004AgentParameters;
import cz.cuni.amis.pogamut.usar2004.factory.guice.remoteagent.USAR2004BotFactory;
import cz.cuni.amis.pogamut.usar2004.factory.guice.remoteagent.USAR2004BotModule;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import javax.vecmath.Point4f;

/**
 * Class used for creating, connecting and starting servers with default settings that are taken from the properties.
 * <p><p>
 * The address where the instances will connect are defined either in the constructor
 * or taken from the properties of the {@link PogamutPlatform}.
 * <p><p>
 * For more information about the class see {@link AgentRunner}.
 *
 * @author ik
 * @author Jimmy
 *
 * @param <BOT>
 * @param <PARAMS>
 */
public class USAR2004BotRunner<BOT extends USAR2004Bot, PARAMS extends USAR2004AgentParameters> extends AgentRunner<BOT, PARAMS> {

	/**
	 * Default host where the instances are going to be connected as defaults, see {@link IAgentParameters#assignDefaults(IAgentParameters)}.
	 */
    protected String host;

    /**
	 * Default port where the instances are going to be connected as defaults, see {@link IAgentParameters#assignDefaults(IAgentParameters)}.
	 */
    protected int port;

    /**
	 * Default name that will serve as a basis for {@link IAgentId}, see {@link IAgentParameters#assignDefaults(IAgentParameters)}.
	 */
	protected String name;

	/**
	 * Construct the runner + specify all defaults.
	 *
	 * @param factory to be used for creating new {@link IUSAR2004Bot} instances
	 * @param name default name that serve as a basis for {@link IAgentId}
	 * @param host default host where the instances are going to be connected
	 * @param port default port where the instances are going to be connected
	 */
	public USAR2004BotRunner(IAgentFactory<BOT, PARAMS> factory, String name, String host, int port) {
        super(factory);
        this.name = name;
        this.port = port;
        this.host = host;
    }

	/**
	 * Construct the runner + specify the default name, host:port will be taken from the Pogamut platform properties.
	 *
	 * @param factory factory to be used for creating new {@link IUSAR2004Bot} instances
	 * @param log used to log stuff
	 * @param name default name that serve as a basis for {@link IAgentId}
	 */
    /*public USAR2004BotRunner(IAgentFactory<BOT, PARAMS> factory, String name) {
        this(
        	factory,
        	name,
        	Pogamut.getPlatform().getProperty(PogamutUSAR2004Property.POGAMUT_USAR2004_BOT_HOST.getKey()),
        	Pogamut.getPlatform().getIntProperty(PogamutUSAR2004Property.POGAMUT_USAR2004_BOT_PORT.getKey())
        );
    }*/

    /**
     * Construct the runner without specifying anything as default. Default name for bots will be "USAR2004Bot"
     * and host:port will be taken from the Pogamut platform properties.
     *
     * @param factory factory to be used for creating new {@link IUSAR2004Bot} instances
     */
   /* public USAR2004BotRunner(IAgentFactory<BOT, PARAMS> factory) {
        this(factory, "USAR2004Bot");
    }*/

    /**
	 * Construct the runner + specify all defaults.
	 *
	 * @param module Guice module that is going to be used by the {@link USAR2004BotFactory}
	 * @param name default name that serve as a basis for {@link IAgentId}
	 * @param host default host where the instances are going to be connected
	 * @param port default port where the instances are going to be connected
	 */
	public USAR2004BotRunner(USAR2004BotModule module, String name, String host, int port) {
        this(new USAR2004BotFactory<BOT, PARAMS>(module), name, host, port);
    }

	/**
	 * Construct the runner + specify the default name, host:port will be taken from the Pogamut platform properties.
	 *
	 * @param module Guice module that is going to be used by the {@link USAR2004BotFactory}
	 * @param name default name that serve as a basis for {@link IAgentId}
	 */
    /*public USAR2004BotRunner(USAR2004BotModule module, String name) {
        this(
        	module,
        	name,
        	Pogamut.getPlatform().getProperty(PogamutUSAR2004Property.POGAMUT_USAR2004_BOT_HOST.getKey()),
        	Pogamut.getPlatform().getIntProperty(PogamutUSAR2004Property.POGAMUT_USAR2004_BOT_PORT.getKey())
        );
    }*/

    /**
     * Construct the runner without specifying anything as default. Default name for bots will be "USAR2004Bot"
     * and host:port will be taken from the Pogamut platform properties.
     *
	 * @param module Guice module that is going to be used by the {@link USAR2004BotFactory}
	 */
   /* public USAR2004BotRunner(USAR2004BotModule module) {
        this(module, "USAR2004Bot");
    }*/

    /**
	 * Construct the runner + specify all defaults.
	 *
	 * @param botControllerClass controller that will be used to instantiate {@link USAR2004BotModule}, i.e., it will control the {@link USAR2004Bot} instance
	 * @param name default name that serve as a basis for {@link IAgentId}
	 * @param host default host where the instances are going to be connected
	 * @param port default port where the instances are going to be connected
	 */
	public USAR2004BotRunner(Class<? extends IUSAR2004BotController> botControllerClass, String name, String host, int port) {
        this(new USAR2004BotModule(botControllerClass), name, host, port);
    }

	/**
	 * Construct the runner + specify the default name, host:port will be taken from the Pogamut platform properties.
	 *
	 * @param botControllerClass controller that will be used to instantiate {@link USAR2004BotModule}, i.e., it will control the {@link USAR2004Bot} instance
	 * @param name default name that serve as a basis for {@link IAgentId}
	 */
   /* public USAR2004BotRunner(Class<? extends IUSAR2004BotController> botControllerClass, String name) {
        this(
        	new USAR2004BotModule(botControllerClass),
        	name,
        	Pogamut.getPlatform().getProperty(PogamutUSAR2004Property.POGAMUT_USAR2004_BOT_HOST.getKey()),
        	Pogamut.getPlatform().getIntProperty(PogamutUSAR2004Property.POGAMUT_USAR2004_BOT_PORT.getKey())
        );
    }*/ 

    /**
     * Construct the runner without specifying anything as default. Default name for bots will be "USAR2004Bot"
     * and host:port will be taken from the Pogamut platform properties.
     *
	 * @param botControllerClass controller that will be used to instantiate {@link USAR2004BotModule}, i.e., it will control the {@link USAR2004Bot} instance
	 */
 /*   public USAR2004BotRunner(Class<? extends IUSAR2004BotController> botControllerClass) {
        this(new USAR2004BotModule(botControllerClass), "USAR2004Bot");
    }*/

    @Override
    public BOT startAgent() throws PogamutException {
    	return super.startAgent();
    }

    @Override
    public List<BOT> startAgents(int count) throws PogamutException {
    	return super.startAgents(count);
    }

    @Override
    public List<BOT> startAgents(PARAMS... agentParameters) throws PogamutException {
    	return super.startAgents(agentParameters);
    };

    /**
     * Returns name that is going to be used to form new {@link IAgentId} of the bots.
     *
     * @return name used for the newly started bots
     */
    public String getName() {
		return name;
	}

    /**
     * Sets name that is going to be used to form new {@link IAgentId} of the bots.
     * <p><p>
     * If null is passed, generic "USAR2004Bot" will be set.
     *
     * @param name name used for the newly started bots
     * @return this instance
     */
	public USAR2004BotRunner<BOT, PARAMS> setName(String name) {
		if (name == null) name = "USAR2004Bot";
		this.name = name;
		return this;
	}

	/**
     * Returns host, where newly launched bots will be connected to.
     *
     * @return host running GB2004 server
     */
    public String getHost() {
		return host;
	}

    /**
     * Sets host, where newly launched bots will be connected to.
     *
     * @param host host running GB2004 server (can't be null)
     * @return this instance
     */
	public USAR2004BotRunner<BOT, PARAMS> setHost(String host) {
		this.host = host;
		NullCheck.check(this.host, "host");
		return this;
	}

	/**
     * Returns port, where newly launched bots will be connected to.
     *
     * @return port at the host where GB2004 server is listening for bot connections
     */
	public int getPort() {
		return port;
	}

	/**
     * Sets port, where newly launched bots will be connected to.
     *
     * @param port at the host where GB2004 server is listening for bot connections
     * @return this instance
     */
	public USAR2004BotRunner<BOT, PARAMS> setPort(int port) {
		this.port = port;
		return this;
	}

    /**
     * Provides default parameters that is, {@link IAgentId} using {@link USAR2004BotRunner#name} and {@link SocketConnectionAddress}
     * using {@link USAR2004BotRunner#host} and {@link USAR2004BotRunner#port}.
     */
	@Override
	protected IAgentParameters newDefaultAgentParameters() {
		return new USAR2004AgentParameters().setAgentId(newAgentId(name)).setWorldAddress(new SocketConnectionAddress(host, port));
	}

}
