/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes;

import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.LinkState;
import java.util.ArrayList;
import java.util.List;

public class LinkStateSet {
    private List<Integer> links = new ArrayList<Integer>();
    private List<Double> values = new ArrayList<Double>();
    private List<Double> torques = new ArrayList<Double>();

    public void add(int l, double v, double t) {
        this.links.add(l);
        this.values.add(v);
        this.torques.add(t);
    }

    public void add(LinkState ls) {
        this.links.add(ls.getLink());
        this.values.add(ls.getValue());
        this.torques.add(ls.getTorque());
    }

    public void addLink(int l) {
        this.links.add(l);
    }

    public void addValue(double v) {
        this.values.add(v);
    }

    public void addTorque(double t) {
        this.torques.add(t);
    }

    public List<LinkState> GetLinkStateList() {
        try {
            if (this.links.size() != this.values.size() || this.links.size() != this.torques.size()) {
                throw new Exception("Could not convert! Arrays are of different sizes!");
            }
            ArrayList<LinkState> returnee = new ArrayList<LinkState>();
            for (int i = 0; i < this.links.size(); ++i) {
                LinkState l = new LinkState(this.links.get(i), this.values.get(i), this.torques.get(i));
                returnee.add(l);
            }
            return returnee;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isEmpty() {
        return this.links.isEmpty();
    }
}

