/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.agent.module.logic;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base3d.ILockableVisionWorldView;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.module.logic.USAR2004BotLogic;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SyncUSAR2004BotLogic<BOT extends USAR2004Bot<? extends ILockableVisionWorldView, ?, ?>>
extends USAR2004BotLogic<BOT> {
    @Inject
    public SyncUSAR2004BotLogic(BOT agent, IAgentLogic logic) {
        this(agent, logic, null, new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add((IComponent)agent.getWorldView()));
    }

    public SyncUSAR2004BotLogic(BOT agent, IAgentLogic logic, Logger log) {
        this(agent, logic, log, new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add((IComponent)agent.getWorldView()));
    }

    public SyncUSAR2004BotLogic(BOT agent, IAgentLogic logic, Logger log, ComponentDependencies dependencies) {
        super(agent, logic, log, dependencies);
    }

    protected void beforeLogic(String threadName) {
        super.beforeLogic(threadName);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(threadName + ": Locking world view.");
        }
        ((ILockableVisionWorldView)((USAR2004Bot)this.agent).getWorldView()).lock();
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer(threadName + ": World view locked.");
        }
    }

    protected void afterLogic(String threadName) {
        super.afterLogic(threadName);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(threadName + ": Unlocking world view.");
        }
        ((ILockableVisionWorldView)((USAR2004Bot)this.agent).getWorldView()).unlock();
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer(threadName + ": World view unlocked.");
        }
    }

    protected void afterLogicException(String threadName, Throwable e) {
        super.afterLogicException(threadName, e);
        if (((ILockableVisionWorldView)((USAR2004Bot)this.agent).getWorldView()).isLocked()) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Unlocking world view.");
            }
            ((ILockableVisionWorldView)((USAR2004Bot)this.agent).getWorldView()).unlock();
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view unlocked.");
            }
        }
    }

    protected boolean shouldExecuteLogic() {
        return true;
    }
}

