/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.usar2004.samples.AirScanner;

import math.geom2d.Point2D;

/**
 *
 * @author vejmanm
 */
public class Obstacle1
{
    public static final double obstacleSize = 1d;
    public static final double joinDistance = 1.5d;
    public static final double maxExtendRatio = 4;
    public static final double maxEdgeSize = 5;
    private Point2D start;
    private Point2D stop;

    public Obstacle1(Point2D corner, double width, double height)
    {
        this.start = corner;
        this.stop = new Point2D(corner.x + width, corner.y + height);
    }

    public Obstacle1(Point2D start, Point2D stop)
    {
        this.start = start;
        this.stop = stop;
    }

    /**
     * Initial constructor, center is the center of an obstacle, width and
     * height is given by robot dimension(0.5). From the center point it is
     * computed the corner Point also.
     *
     * @param center Center of a new obstacle.
     */
    public Obstacle1(Point2D center)
    {
        this(center.x, center.y);
    }

    public Obstacle1(double centerX, double centerY)
    {
        this.start = new Point2D(centerX - obstacleSize / 2, centerY - obstacleSize / 2);
        this.stop = new Point2D(centerX + obstacleSize / 2, centerY + obstacleSize / 2);
    }

    /**
     * Extends obstacle bounds when new obstacle found near existing one.
     *
     * @param x X coordinate of the centre of a new obstacle
     * @param y Y coordinate of the centre of a new obstacle
     * @return Returns true if obstacle was extended, false otherwise
     */
    private boolean extend(double x, double y)
    {
        boolean success = false;

        if(x + obstacleSize / 2 > stop.x)
        {
            stop.x = x + obstacleSize / 2;
            success = true;
        }
        if(y + obstacleSize / 2 > stop.y)
        {
            stop.y = y + obstacleSize / 2;
            success = true;
        }
        if(x - obstacleSize / 2 < start.x)
        {
            start.x = x - obstacleSize / 2;
            success = true;
        }
        if(y - obstacleSize / 2 < start.y)
        {
            start.y = y - obstacleSize / 2;
            success = true;
        }

        return success;
    }

    // <editor-fold desc="Getters" defaultstatestate="collapsed"> 
    public double getWidth()
    {
        return stop.x - start.x;
    }

    public double getHeight()
    {
        return stop.y - start.y;
    }

    public Point2D getCorner()
    {
        return start;
    }
    // </editor-fold>

    /**
     * If new Obstacle [x,y] is within the distance of joinDistance, i will
     * extend this Obstacle boundbox by this point [x,y] plus its own boundbox
     * of obstacleSize. If a small square is within the absorb region of this
     * rectangle, it will enlarge itself to absorb this square so we don't need
     * to create a new obstacle object.
     *
     * @param x x coordinate of new obstacle (Obstacle of a minimum size)
     * @param y y coordinate of new obstacle (Obstacle of a minimum size)
     * @return Returns Can = 1, Can not = -1 and is already inside = 0
     */
    public Obstacle1 tryExtend(double x, double y)
    {
        if(x > this.start.x - joinDistance
                && x < this.stop.x + joinDistance
                && y > this.start.y - joinDistance
                && y < this.stop.y + joinDistance)
        {
            if(extend(x, y))
                extendCount++;
            return this;
        }
        return null;
    }
    private int extendCount = 0;

    /**
     * If Obstacle grows only one dimension enough we don't want to extend it
     * nomore. It is good to have more smaller more accurate than fewer larger
     * and sitorted obstacle boundboxes.
     *
     * @return Returns if obstacle is able to grow
     */
    public boolean canExtend()
    {
        return extendCount<3;
//        double width = Math.abs(start.x - stop.x);
//        double height = Math.abs(start.y - stop.y);
//        double edgeRatio = width / height;
//        if(edgeRatio > maxEdgeSize || edgeRatio < 1 / maxEdgeSize)
//        {
//            return false;
//        }
//        if(width > maxEdgeSize || height > maxEdgeSize)
//        {
//            return false;
//        }
//        return true;
    }

    public boolean isInside(double x, double y)
    {
        if(x > this.start.x
                && x < this.stop.x
                && y > this.start.y
                && y < this.stop.y)
        {
            return true;
        }
        return false;
    }

    public boolean isWithin(double x, double y)
    {
        if(x > this.start.x - obstacleSize / 2
                && x < this.stop.x + obstacleSize / 2
                && y > this.start.y - obstacleSize / 2
                && y < this.stop.y + obstacleSize / 2)
        {
            return true;
        }
        return false;
    }

    public static Obstacle1 MergeObstacles(Obstacle1 blockA, Obstacle1 blockB)
    {
        //shorter terms
        double xA = blockA.start.x;
        double xB = blockB.start.x;
        double yA = blockA.start.y;
        double yB = blockB.start.y;
        //C = right lower corner of block A
        //D = right lower corner of block B
        double xC = blockA.start.x;
        double yC = blockA.start.y;
        double xD = blockB.stop.x;
        double yD = blockB.stop.y;
        //leftest and highest Point
        Point2D newStart = new Point2D(Math.min(xA, xB), Math.min(yA, yB));
        Point2D newStop = new Point2D(Math.min(xC, xD), Math.min(yC, yD));
        return new Obstacle1(newStart, newStop);
    }
}
