package cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands;

import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * Drive command specified for a sub or a boat.
 *
 * Corresponding GameBots command is DRIVE.
 *
 */
public class DriveNautic extends CommandMessage
{
    //constructor for the third type
    public DriveNautic(double Propeller, double Rudder, double SternPlane, boolean Normalized, boolean Light)
    {
        this.Propeller = Propeller;
        this.Rudder = Rudder;
        this.SternPlane = SternPlane;
        this.Normalized = Normalized;
        this.Light = Light;
    }

    /**
     * <p></p>WARNING: this is empty-command constructor, you have to use
     * setters to fill it up!
     */
    public DriveNautic()
    {
    }
    /////// Properties BEGIN
    //third type - Propeller, Rudder, SternPlane, Normalized, Light
    /*
     * the spin speed for the propellers. If we use normalized values, the value
     * range is –100 to 100 and corresponds to the propeller’s minimum and
     * maximum spin speed, respectively. Otherwise, the value is the absolute
     * propeller’s spin speed, in radians per second.
     */
    protected double Propeller = 0;

    public double getPropeller()
    {
        return Propeller;
    }

    public DriveNautic setPropeller(double Propeller)
    {
        this.Propeller = Propeller;
        return this;
    }
    /*
     * specifies the angle of the robot’s rudders. If we use normalized values,
     * the value range is -100 to 100 and corresponds to the rudders’ minimum
     * and maximum steer angle, respectively. Otherwise, the value is the
     * absolute rudder angle, in radians.
     */
    protected double Rudder = 0;

    public double getRudder()
    {
        return Rudder;
    }

    public DriveNautic setRudder(double Rudder)
    {
        this.Rudder = Rudder;
        return this;
    }
    /*
     * specifies the angle of the robot’s stern planes. If we use normalized
     * values, the value range is -100 to 100 and corresponds to the stern
     * planes’ minimum and maximum angle, respectively. Otherwise, the value is
     * the absolute stern plane angle, in radians.
     */
    protected double SternPlane = 0;

    public double getSternPlane()
    {
        return SternPlane;
    }

    public DriveNautic setSternPlane(double SternPlane)
    {
        this.SternPlane = SternPlane;
        return this;
    }
    /*
     * Indicates whether we are using normalized values or ´ * not. The default
     * value is ‘False’ which means absolute values are used to control wheel
     * spin speed.
     */
    protected boolean Normalized = false;

    public boolean isNormalized()
    {
        return Normalized;
    }

    public DriveNautic setNormalized(boolean Normalized)
    {
        this.Normalized = Normalized;
        return this;
    }
    //Indicates whether to turn the headlight on or off
    protected boolean Light = false;

    public boolean isLight()
    {
        return Light;
    }

    public DriveNautic setLight(boolean Light)
    {
        this.Light = Light;
        return this;
    }

    /*
     * Example: Drive {Propeller 1.0} will Drive the robot forward with a
     * propeller’s spin speed of 1 rad/sec. Drive {Propeller 1.0} {Rudder
     * 0.523599} will Drive the robot 30° forward and to the right with a spin
     * speed of 1 rad/sec. Drive {Speed 1.0} {FrontSteer -0.523599} will Drive
     * the robot 30° forward and to the left with a spin speed of 1 rad/sec.
     * Drive {Light true} will turn on the robot’s headlights.
     */
    /////// Properties END
    /////// Extra Java code BEGIN
    /////// Additional code from xslt BEGIN
    /////// Additional code from xslt END
    /////// Extra Java from XML BEGIN
    /////// Extra Java from XML END
    /////// Extra Java code END
    /**
     * Cloning constructor.
     */
    public DriveNautic(DriveNautic original)
    {
        this.Normalized = original.Normalized;
        this.Light = original.Light;
        this.Propeller = original.Propeller;
        this.Rudder = original.Rudder;
        this.SternPlane = original.SternPlane;
    }

    @Override
    public String toString()
    {
        return toMessage();
    }

    public String toHtmlString()
    {
        return super.toString()
                + "<b>Normalized</b> : "
                + String.valueOf(Normalized)
                + " <br/> "
                + "<b>Light</b> : "
                + String.valueOf(Light)
                + " <br/> "
                + "<b>Propeller</b> : "
                + String.valueOf(Propeller)
                + " <br/> "
                + "<b>Rudder</b> : "
                + String.valueOf(Rudder)
                + " <br/> "
                + "<b>SternPlane</b> : "
                + String.valueOf(SternPlane)
                + " <br/> "
                + "";
    }

    public String toMessage()
    {
        StringBuilder buf = new StringBuilder();
        buf.append("DRIVE");
        buf.append(" {Normalized ").append(Normalized).append("}");
        buf.append(" {Light ").append(Light).append("}");
        buf.append(" {Propeller ").append(Propeller).append("}");
        buf.append(" {Rudder ").append(Rudder).append("}");
        buf.append(" {SternPlane ").append(SternPlane).append("}");

        return buf.toString();
    }
}
