package cz.cuni.amis.pogamut.usar2004.agent.module.sensor;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.OdometryPose;

/**
 * Sensor message representative for Odometry sensor.
 *
 * @author vejmanm
 */
public class SensorOdometry extends SuperSensor
{
    //public static final String type="Odometry";
    public static final SensorType type = SensorType.ODOMETRY_SENSOR;

    /**
     * Ctor. Sensor type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public SensorOdometry()
    {
        super(type);
    }

    /**
     * OdoPose is the estimated robot position relative to the start point in
     * meters. ‘theta’ is the head angle in radians relative to the start
     * orientation.
     *
     * @return Returns OdometryPose value.
     */
    public OdometryPose getPose()
    {
        return lastMessage.getOdoPose();
    }
}
