/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.agent.module.master;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.StateContainer;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.VehicleType;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.MissionPackageModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.ModuleInstanceProvider;
import cz.cuni.amis.pogamut.usar2004.agent.module.state.SuperState;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.StateMessage;
import java.util.List;

public class StateMasterModule
extends SensorModule<USAR2004Bot> {
    protected StateMessageListener stateListener;
    protected static StateMasterModule singleton = null;
    protected StateContainer stateModule = new StateContainer();
    protected MissionPackageModule packageModule;

    private StateMasterModule(USAR2004Bot bot) {
        super((IObservingAgent)bot);
        this.stateListener = new StateMessageListener(this.worldView);
        this.packageModule = MissionPackageModule.getModuleInstance(bot);
    }

    public static StateMasterModule getModuleInstance(USAR2004Bot bot) {
        if (singleton == null) {
            singleton = new StateMasterModule(bot);
        }
        return singleton;
    }

    public Boolean isReady() {
        if (this.stateModule != null && !this.stateModule.isEmpty()) {
            return true;
        }
        return false;
    }

    public SuperState getStatesByType(String type) {
        if (type == null) {
            return null;
        }
        return this.stateModule.getStatesByType(type.toLowerCase());
    }

    public SuperState getStatesByVehilceType(VehicleType type) {
        return this.stateModule.getStatesByVehicleType(type);
    }

    public List<SuperState> getStatesByClass(Class c) {
        return this.stateModule.getStatesByClass(c);
    }

    public List<String> getAvailibleTypes() {
        return this.stateModule.getAvailibleTypes();
    }

    protected SuperState createNewState(StateMessage message) {
        return ModuleInstanceProvider.getStateInstanceByType(message.getType());
    }

    protected boolean updateStateCollection(StateMessage message) {
        if (!this.stateModule.containsKey(message.getType().toLowerCase())) {
            return false;
        }
        ((SuperState)this.stateModule.get(message.getType().toLowerCase())).updateMessage(message);
        return true;
    }

    protected void fileMessage(StateMessage message) {
        if (this.updateStateCollection(message)) {
            return;
        }
        SuperState newState = this.createNewState(message);
        if (newState == null) {
            System.out.println("This state is not supported! " + message.getType());
            return;
        }
        String type = message.getType().toLowerCase();
        newState.updateMessage(message);
        this.stateModule.put(type, newState);
    }

    public MissionPackageModule getMissionPackageModule() {
        return this.packageModule;
    }

    protected void cleanUp() {
        super.cleanUp();
        this.stateListener = null;
        this.stateModule = null;
        singleton = null;
    }

    private class StateMessageListener
    implements IWorldEventListener<StateMessage> {
        public void notify(StateMessage event) {
            StateMasterModule.this.fileMessage(event);
        }

        public StateMessageListener(IWorldView worldView) {
            worldView.addEventListener(StateMessage.class, (IWorldEventListener)this);
        }
    }
}

