/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.unreal.communication.worldview.map;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealMapInfo;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class MapInfo
implements IUnrealMapInfo {
    private String name = "";
    public Location[] imagePoints = new Location[3];
    public Location[] worldPoints = new Location[3];
    public int width;
    public int height;
    public byte[] imgData;

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public byte[] getImgRGBData() {
        return this.imgData;
    }

    @Override
    public void setImage(String path) throws IOException {
        BufferedImage img = null;
        img = ImageIO.read(new File(path));
        this.width = img.getWidth();
        this.height = img.getHeight();
        this.imgData = new byte[img.getHeight() * img.getWidth() * 3];
        int pos = 0;
        int row = img.getHeight() - 1;
        while (row >= 0) {
            int col = 0;
            while (col < img.getWidth()) {
                int pixel = img.getRGB(col, row);
                this.imgData[pos++] = (byte)(pixel >> 16 & 0xFF);
                this.imgData[pos++] = (byte)(pixel >> 8 & 0xFF);
                this.imgData[pos++] = (byte)(pixel >> 0 & 0xFF);
                ++col;
            }
            --row;
        }
    }

    @Override
    public void setImagePoint(int i, Location l) {
        this.imagePoints[i] = new Location(l);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setWorldPos(int i, Location l) {
        this.worldPoints[i] = new Location(l);
    }

    @Override
    public Location[] getImagePoints() {
        return this.imagePoints;
    }

    @Override
    public Location[] getWorldPoints() {
        return this.worldPoints;
    }
}

