/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.server;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.params.impl.RemoteAgentParameters;
import cz.cuni.amis.pogamut.base.agent.utils.AgentKeepAlive;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.udk.factory.guice.remoteagent.UDKServerFactory;
import cz.cuni.amis.pogamut.udk.factory.guice.remoteagent.UDKServerModule;
import cz.cuni.amis.pogamut.udk.server.IUDKServer;
import cz.cuni.amis.pogamut.udk.server.exception.UCCStartException;
import cz.cuni.amis.pogamut.udk.test.BaseUDKTest;
import cz.cuni.amis.pogamut.udk.utils.PogamutUDKProperty;
import cz.cuni.amis.pogamut.udk.utils.UCCWrapper;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class UDKTest09_UDKServer_SetGameMap_AgentKeepAlive2
extends BaseUDKTest {
    private static Random random = new Random(System.currentTimeMillis());
    private static final Level LOG_LEVEL = Level.INFO;
    protected static boolean useInternalUcc = !Pogamut.getPlatform().getProperty(PogamutUDKProperty.POGAMUT_UNREAL_TEST_EXT_SERVER.getKey()).equals("true");
    private UCCWrapper uccWrapper;
    IUDKServer server;
    UDKServerFactory factory;

    @Override
    @Before
    public void startTest() throws UCCStartException {
        if (useInternalUcc) {
            System.out.println("Starting UCC...");
            this.uccWrapper = new UCCWrapper(new UCCWrapper.UCCWrapperConf().setStartOnUnusedPort(false));
        }
    }

    @Override
    @After
    public void endTest() {
        if (this.server != null) {
            this.server.kill();
        }
        if (useInternalUcc) {
            System.out.println("Stopping UCC...");
            this.uccWrapper.stop();
        }
        System.out.println("Closing PogamutPlatform...");
        Pogamut.getPlatform().close();
    }

    private void changeMap(IUDKServer server, String map) {
        if (this.awaitAgentUp((AbstractAgent)server)) {
            System.out.println("Changing map to '" + map + "'...");
            if (useInternalUcc) {
                System.out.println("UCC Host - " + this.uccWrapper.getHost() + ", Port - " + this.uccWrapper.getControlPort());
            }
            Future future = server.setGameMap(map);
            try {
                System.out.println("Waiting for the GBUDK to change the map (60sec timeout).");
                Boolean result = (Boolean)future.get(60000L, TimeUnit.MILLISECONDS);
                if (result == null || !result.booleanValue()) {
                    Assert.fail((String)("Failed to change map to '" + map + "'."));
                }
            }
            catch (Exception e) {
                Assert.fail((String)("Failed to change map to '" + map + "'."));
            }
        } else {
            Assert.fail((String)"Failed to connect to GBUDK...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test01_SetGameMap() {
        String host = "localhost";
        int port = 3001;
        if (useInternalUcc) {
            host = this.uccWrapper.getHost();
            port = this.uccWrapper.getControlPort();
        }
        this.factory = new UDKServerFactory(new UDKServerModule());
        AgentId agentId = new AgentId("Test-ChangeMap");
        this.server = (IUDKServer)this.factory.newAgent((IAgentParameters)new RemoteAgentParameters().setAgentId((IAgentId)agentId).setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress(host, port)));
        AbstractAgent serverAgent = (AbstractAgent)this.server;
        serverAgent.getLogger().setLevel(LOG_LEVEL);
        serverAgent.getLogger().addDefaultConsoleHandler();
        AgentKeepAlive keepAlive = new AgentKeepAlive((IAgent)serverAgent, 1000L);
        keepAlive.start();
        if (!this.awaitAgentUp(serverAgent)) {
            Assert.fail((String)"Failed to connect to GBUDK.");
        } else {
            System.out.println("Connected...");
        }
        String[] maps = new String[]{"DM-Deck", "DM-Sanctuary"};
        try {
            for (int i = 0; i < 5; ++i) {
                System.out.println("ChangeMap + AgentKeepAlive test: " + (i + 1) + " / 5...");
                for (int j = 0; j < 5; ++j) {
                    System.out.println("Change map " + (j + 1) + " / 5...");
                    this.changeMap(this.server, maps[random.nextInt(maps.length)]);
                }
                if (useInternalUcc) {
                    System.out.println("Stopping UCC...");
                    this.uccWrapper.stop();
                }
                try {
                    this.awaitAgentDown(serverAgent);
                }
                catch (Exception e) {
                    System.out.println("???");
                }
                if (i == 4) {
                    break;
                }
                if (useInternalUcc) {
                    System.out.println("Starting UCC...");
                    this.uccWrapper = new UCCWrapper(new UCCWrapper.UCCWrapperConf());
                    this.server.setAddress(this.uccWrapper.getHost(), this.uccWrapper.getControlPort());
                }
                try {
                    this.awaitAgentUp(serverAgent);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("???");
                }
            }
        }
        finally {
            try {
                keepAlive.stop();
            }
            finally {
                this.server.kill();
            }
        }
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        UDKTest09_UDKServer_SetGameMap_AgentKeepAlive2 test = new UDKTest09_UDKServer_SetGameMap_AgentKeepAlive2();
        test.startTest();
        test.test01_SetGameMap();
        test.endTest();
    }
}

