/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.agent.navigation.martinnavigator;

import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.udk.agent.navigation.AbstractUDKPathNavigator;
import cz.cuni.amis.pogamut.udk.agent.navigation.IUDKPathRunner;
import cz.cuni.amis.pogamut.udk.agent.navigation.martinnavigator.MartinRunner;
import cz.cuni.amis.pogamut.udk.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.utils.NullCheck;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MartinNavigator<PATH_ELEMENT extends ILocated>
extends AbstractUDKPathNavigator<PATH_ELEMENT> {
    public static final int CLOSE_ENOUGH = 60;
    public static final int PRECISION = 100;
    private Location navigDestination = null;
    private Stage navigStage = Stage.COMPLETED;
    private Iterator<PATH_ELEMENT> navigIterator = null;
    private int navigNextLocationOffset = 0;
    private Location navigCurrentLocation = null;
    private NavPoint navigCurrentNode = null;
    private NavPointNeighbourLink navigCurrentLink = null;
    private Location navigNextLocation = null;
    private NavPoint navigNextNode = null;
    private IUDKPathRunner runner;
    protected UDKBot main;
    protected AgentInfo memory;
    protected AdvancedLocomotion body;
    protected Logger log;

    @Override
    public double getPrecision() {
        return 100.0;
    }

    @Override
    protected void navigate(int pathElementIndex) {
        this.navigStage = this.keepNavigating();
        switch (this.navigStage) {
            case NAVIGATING: 
            case REACHING: {
                return;
            }
            case CRASHED: {
                this.executor.stuck();
                return;
            }
            case COMPLETED: {
                this.executor.targetReached();
                return;
            }
        }
    }

    @Override
    public void reset() {
        this.navigCurrentLocation = null;
        this.navigCurrentNode = null;
        this.navigCurrentLink = null;
        this.navigDestination = null;
        this.navigIterator = null;
        this.navigNextLocation = null;
        this.navigNextNode = null;
        this.navigNextLocationOffset = 0;
        this.navigStage = Stage.COMPLETED;
    }

    @Override
    public void newPath(List<PATH_ELEMENT> path) {
        Location dest = ((ILocated)path.get(path.size() - 1)).getLocation();
        this.initPathNavigation(dest, path);
    }

    protected void initPathNavigation(Location destination, List<PATH_ELEMENT> path) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("LoqueNavigator.initPathNavigation(): initializing path navigation, nodes " + path.size());
        }
        if (!this.initAlongPath(destination, path)) {
            this.initDirectNavigation(destination);
        }
    }

    protected boolean initAlongPath(Location dest, List<PATH_ELEMENT> path) {
        this.navigDestination = dest;
        this.navigIterator = path.iterator();
        this.navigCurrentLocation = null;
        this.navigCurrentNode = null;
        this.prepareNextNode();
        this.navigStage = Stage.NAVIGATING;
        return this.switchToNextNode();
    }

    protected void initDirectNavigation(Location dest) {
        this.initDirectly(dest);
    }

    protected Stage initDirectly(Location dest) {
        this.navigDestination = dest;
        this.runner.reset();
        this.navigStage = Stage.REACHING;
        return this.navigStage;
    }

    protected Stage keepNavigating() {
        if (this.navigStage.terminated) {
            return this.navigStage;
        }
        switch (this.navigStage) {
            case REACHING: {
                this.navigStage = this.navigDirectly();
                break;
            }
            default: {
                this.navigStage = this.navigAlongPath();
            }
        }
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Navigator.keepNavigating(): navigation stage " + (Object)((Object)this.navigStage));
        }
        return this.navigStage;
    }

    private Stage navigDirectly() {
        int distance = (int)this.memory.getLocation().getDistance(this.navigDestination);
        if ((double)distance <= this.getPrecision()) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("LoqueNavigator.navigDirectly(): destination close enough: " + distance);
            }
            return Stage.COMPLETED;
        }
        if (!this.runner.runToLocation(this.navigDestination, null, this.navigDestination, null, true)) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("LoqueNavigator.navigDirectly(): direct navigation failed");
            }
            return Stage.CRASHED;
        }
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.finest("LoqueNavigator.navigDirectly(): traveling directly, distance = " + distance);
        }
        return this.navigStage;
    }

    protected NavPoint getNavPoint(ILocated location) {
        if (location instanceof NavPoint) {
            return (NavPoint)location;
        }
        NavPoint np = (NavPoint)DistanceUtils.getNearest(this.main.getWorldView().getAll(NavPoint.class).values(), (ILocated)location);
        if (np.getLocation().getDistance(location.getLocation()) < 60.0) {
            return np;
        }
        return null;
    }

    private Stage navigAlongPath() {
        int totalDistance = (int)this.memory.getLocation().getDistance(this.navigDestination);
        if ((double)totalDistance <= this.getPrecision()) {
            this.log.finest("Navigator.navigAlongPath(): destination close enough: " + totalDistance);
            return Stage.COMPLETED;
        }
        return this.navigToCurrentNode();
    }

    private void prepareNextNode() {
        ILocated located = null;
        this.navigNextLocation = null;
        this.navigNextLocationOffset = 0;
        while (located == null && this.navigIterator.hasNext()) {
            located = (ILocated)this.navigIterator.next();
            ++this.navigNextLocationOffset;
            if (located != null) continue;
        }
        if (located == null) {
            this.navigNextLocationOffset = 0;
            return;
        }
        if (this.executor.getPathElementIndex() + this.navigNextLocationOffset >= this.executor.getPath().size()) {
            this.navigNextLocationOffset = 0;
        }
        this.navigNextLocation = located.getLocation();
        this.navigNextNode = this.getNavPoint(located);
    }

    private boolean switchToNextNode() {
        Location navigLastLocation = this.navigCurrentLocation;
        NavPoint navigLastNode = this.navigCurrentNode;
        this.navigCurrentLocation = this.navigNextLocation;
        if (null == this.navigCurrentLocation) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("Navigator.switchToNextNode(): no nodes left");
            }
            this.navigCurrentNode = null;
            return false;
        }
        this.navigCurrentNode = this.navigNextNode;
        this.navigCurrentLink = this.getNavPointsLink(navigLastNode, this.navigCurrentNode);
        if (navigLastLocation == null) {
            navigLastLocation = this.navigCurrentLocation;
            navigLastNode = this.navigCurrentNode;
        }
        int localDistance = (int)this.memory.getLocation().getDistance(this.navigCurrentLocation.getLocation());
        if (this.navigCurrentNode == null) {
            this.runner.reset();
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("LoqueNavigator.switchToNextNode(): switch to next location " + this.navigCurrentLocation + ", distance " + localDistance);
            }
        } else {
            this.runner.reset();
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("LoqueNavigator.switchToNextNode(): switch to next node " + this.navigCurrentNode.getId().getStringId() + ", distance " + localDistance + ", reachable " + this.isReachable(this.navigCurrentNode));
            }
        }
        if (this.executor.getPathElementIndex() < 0) {
            this.executor.switchToAnotherPathElement(0);
        } else if (this.navigNextLocationOffset > 0) {
            this.executor.switchToAnotherPathElement(this.executor.getPathElementIndex() + this.navigNextLocationOffset);
        } else {
            this.executor.switchToAnotherPathElement(this.executor.getPathElementIndex());
        }
        this.navigNextLocationOffset = 0;
        return true;
    }

    private boolean isReachable(NavPoint node) {
        if (node == null) {
            return true;
        }
        int hDistance = (int)this.memory.getLocation().getDistance2D(node.getLocation());
        int vDistance = (int)node.getLocation().getDistanceZ(this.memory.getLocation());
        double angle = hDistance == 0 ? (vDistance == 0 ? 0.0 : (vDistance > 0 ? 1.5707963267948966 : -1.5707963267948966)) : Math.atan(vDistance / hDistance);
        return Math.abs(vDistance) < 30 && Math.abs(angle) < 0.7853981633974483;
    }

    private NavPointNeighbourLink getNavPointsLink(NavPoint start, NavPoint end) {
        if (start == null) {
            NavPoint tmp = this.getNavPoint((ILocated)this.memory.getLocation());
            if (tmp != null) {
                start = tmp;
            } else {
                return null;
            }
        }
        if (end == null) {
            return null;
        }
        if (end.getIncomingEdges().containsKey(start.getId())) {
            return end.getIncomingEdges().get(start.getId());
        }
        return null;
    }

    private Stage navigToCurrentNode() {
        Location focus;
        Location secondLocation;
        if (this.navigCurrentNode != null) {
            this.navigCurrentLocation = this.navigCurrentNode.getLocation();
        }
        int localDistance = (int)this.memory.getLocation().getDistance(this.navigCurrentLocation.getLocation());
        int localDistance2 = (int)this.memory.getLocation().getDistance(Location.add((Location)this.navigCurrentLocation.getLocation(), (Location)new Location(0.0, 0.0, 100.0)));
        Location firstLocation = this.navigCurrentLocation.getLocation();
        if (!this.runner.runToLocation(firstLocation, secondLocation = this.navigNextNode != null && !this.navigNextNode.isLiftCenter() && !this.navigNextNode.isLiftCenter() ? this.navigNextNode.getLocation() : this.navigNextLocation, focus = this.navigNextLocation == null ? firstLocation : this.navigNextLocation.getLocation(), this.navigCurrentLink, this.navigCurrentNode == null ? true : this.isReachable(this.navigCurrentNode))) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("LoqueNavigator.navigToCurrentNode(): navigation to current node failed");
            }
            return Stage.CRASHED;
        }
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.finest("LoqueNavigator.navigToCurrentNode(): traveling to current node, distance = " + localDistance);
        }
        if (this.navigCurrentNode != null && this.navigCurrentNode == this.navigNextNode || this.navigCurrentLocation.equals((Object)this.navigNextLocation)) {
            this.prepareNextNode();
        }
        int testDistance = 200;
        if (this.navigCurrentNode != null && (this.navigCurrentNode.isLiftCenter() || this.navigCurrentNode.isLiftExit())) {
            testDistance = 150;
        }
        if (localDistance < testDistance || localDistance2 < testDistance) {
            if (!this.switchToNextNode()) {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Navigator.navigToCurrentNode(): switch to direct navigation");
                }
                return this.initDirectly(this.navigDestination);
            }
        } else if (this.navigNextLocation != null) {
            localDistance = (int)this.memory.getLocation().getDistance(this.navigNextLocation.getLocation());
            localDistance2 = (int)this.memory.getLocation().getDistance(Location.add((Location)this.navigNextLocation.getLocation(), (Location)new Location(0.0, 0.0, 100.0)));
            if (!(localDistance >= testDistance && localDistance2 >= testDistance || this.switchToNextNode())) {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Navigator.navigToCurrentNode(): switch to direct navigation");
                }
                return this.initDirectly(this.navigDestination);
            }
        }
        return this.navigStage;
    }

    public MartinNavigator(UDKBot bot, Logger log) {
        this.main = bot;
        this.memory = new AgentInfo(bot);
        this.body = new AdvancedLocomotion(bot, log);
        this.log = log;
        this.runner = new MartinRunner(bot, this.memory, this.body, log);
    }

    public MartinNavigator(UDKBot bot, IUDKPathRunner runner, Logger log) {
        this.main = bot;
        this.memory = new AgentInfo(bot);
        this.body = new AdvancedLocomotion(bot, log);
        this.log = log;
        this.runner = runner;
        NullCheck.check((Object)this.runner, (String)"runner");
    }

    public static enum Stage {
        REACHING{

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        NAVIGATING{

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        CRASHED(TerminatingStageType.FAILURE){

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        COMPLETED(TerminatingStageType.SUCCESS){

            @Override
            protected Stage next() {
                return this;
            }
        };

        public boolean terminated;
        public boolean failure;

        private Stage() {
            this.terminated = false;
            this.failure = false;
        }

        private Stage(TerminatingStageType type) {
            this.terminated = true;
            this.failure = type.failure;
        }

        protected abstract Stage next();
    }

    private static enum TerminatingStageType {
        SUCCESS(false),
        FAILURE(true);

        public boolean failure;

        private TerminatingStageType(boolean failure) {
            this.failure = failure;
        }
    }
}

